/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.DonkeyException;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.event.ConnectionStatusEventType;
import com.mirth.connect.donkey.model.event.DeployedStateEventType;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.MessageSerializerException;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProvider;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.channel.Connector;
import com.mirth.connect.donkey.server.channel.MetaDataReplacer;
import com.mirth.connect.donkey.server.channel.ResponseTransformerExecutor;
import com.mirth.connect.donkey.server.channel.StorageSettings;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.event.ConnectionStatusEvent;
import com.mirth.connect.donkey.server.event.DeployedStateEvent;
import com.mirth.connect.donkey.server.event.ErrorEvent;
import com.mirth.connect.donkey.server.message.ResponseValidator;
import com.mirth.connect.donkey.server.queue.DestinationQueue;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.ThreadUtils;
import java.util.Calendar;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DestinationConnector
extends Connector
implements Runnable {
    private static final String QUEUED_RESPONSE = "Message queued successfully";
    private Integer orderId;
    private Map<Long, DestinationQueueThread> queueThreads = new ConcurrentHashMap<Long, DestinationQueueThread>();
    private Deque<Long> processingThreadIdStack;
    private DestinationConnectorProperties destinationConnectorProperties;
    private DestinationQueue queue;
    private int queueEmptySleepTime = 200;
    private String destinationName;
    private boolean enabled;
    private AtomicBoolean forceQueue = new AtomicBoolean(false);
    private AtomicBoolean stopQueue = new AtomicBoolean(false);
    private MetaDataReplacer metaDataReplacer;
    private List<MetaDataColumn> metaDataColumns;
    private ResponseValidator responseValidator;
    private ResponseTransformerExecutor responseTransformerExecutor;
    private StorageSettings storageSettings = new StorageSettings();
    private DonkeyDaoFactory daoFactory;
    private Logger logger = LogManager.getLogger(this.getClass());

    public abstract void replaceConnectorProperties(ConnectorProperties var1, ConnectorMessage var2);

    public abstract Response send(ConnectorProperties var1, ConnectorMessage var2) throws InterruptedException;

    public DestinationQueue getQueue() {
        return this.queue;
    }

    public void setQueue(DestinationQueue queue) {
        this.queue = queue;
    }

    public void setQueueEmptySleepTime(int queueEmptySleepTime) {
        this.queueEmptySleepTime = queueEmptySleepTime;
    }

    public int getPotentialThreadCount() {
        int maxProcessingThreads = ((SourceConnectorPropertiesInterface)((Object)this.getChannel().getSourceConnector().getConnectorProperties())).getSourceConnectorProperties().getProcessingThreads();
        int potentialThreadCount = this.destinationConnectorProperties.isQueueEnabled() ? (!this.destinationConnectorProperties.isSendFirst() ? this.destinationConnectorProperties.getThreadCount() : Math.max(this.destinationConnectorProperties.getThreadCount(), maxProcessingThreads)) : maxProcessingThreads;
        return Math.max(potentialThreadCount, 1);
    }

    private long getDispatcherId() {
        boolean isQueueThread;
        long threadId = Thread.currentThread().getId();
        boolean bl = isQueueThread = this.isQueueEnabled() && this.queueThreads.containsKey(threadId);
        if (isQueueThread) {
            if (this.queueThreads.size() <= 1) {
                return 0L;
            }
            return threadId;
        }
        if (this.getChannel().getProcessingThreads() <= 1) {
            return 0L;
        }
        return this.processingThreadIdStack.pop();
    }

    private void returnProcessingThreadId(long threadId) {
        this.processingThreadIdStack.push(threadId);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isForceQueue() {
        return this.forceQueue.get();
    }

    public void setForceQueue(boolean forceQueue) {
        this.forceQueue.set(forceQueue);
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
    }

    public Serializer getSerializer() {
        return this.channel.getSerializer();
    }

    public MessageMaps getMessageMaps() {
        return this.channel.getMessageMaps();
    }

    @Override
    public void setConnectorProperties(ConnectorProperties connectorProperties) {
        super.setConnectorProperties(connectorProperties);
        if (connectorProperties instanceof DestinationConnectorPropertiesInterface) {
            this.destinationConnectorProperties = ((DestinationConnectorPropertiesInterface)((Object)connectorProperties)).getDestinationConnectorProperties();
        }
    }

    public void setMetaDataReplacer(MetaDataReplacer metaDataReplacer) {
        this.metaDataReplacer = metaDataReplacer;
    }

    public void setMetaDataColumns(List<MetaDataColumn> metaDataColumns) {
        this.metaDataColumns = metaDataColumns;
    }

    public ResponseValidator getResponseValidator() {
        return this.responseValidator;
    }

    public void setResponseValidator(ResponseValidator responseValidator) {
        this.responseValidator = responseValidator;
    }

    public ResponseTransformerExecutor getResponseTransformerExecutor() {
        return this.responseTransformerExecutor;
    }

    public void setResponseTransformerExecutor(ResponseTransformerExecutor responseTransformerExecutor) {
        this.responseTransformerExecutor = responseTransformerExecutor;
    }

    protected void setStorageSettings(StorageSettings storageSettings) {
        this.storageSettings = storageSettings;
    }

    protected void setDaoFactory(DonkeyDaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public boolean isQueueEnabled() {
        return this.destinationConnectorProperties != null && this.destinationConnectorProperties.isQueueEnabled();
    }

    public boolean isQueueRotate() {
        return this.destinationConnectorProperties != null && this.destinationConnectorProperties.isRotate();
    }

    public boolean willAttemptSend() {
        return !this.isQueueEnabled() || this.destinationConnectorProperties.isSendFirst() && this.queue.size() == 0 && !this.isForceQueue() && (this.channel.getQueueHandler() == null || this.channel.getQueueHandler().allowSendFirst(this));
    }

    public boolean includeFilterTransformerInQueue() {
        return this.isQueueEnabled() && this.destinationConnectorProperties.isRegenerateTemplate() && this.destinationConnectorProperties.isIncludeFilterTransformer();
    }

    protected AttachmentHandlerProvider getAttachmentHandlerProvider() {
        return this.channel.getAttachmentHandlerProvider();
    }

    public void updateCurrentState(DeployedState currentState) {
        this.setCurrentState(currentState);
        this.channel.getEventDispatcher().dispatchEvent(new DeployedStateEvent(this.getChannelId(), this.channel.getName(), this.getMetaDataId(), this.destinationName, DeployedStateEventType.getTypeFromDeployedState(currentState)));
    }

    @Override
    public void start() throws ConnectorTaskException, InterruptedException {
        this.updateCurrentState(DeployedState.STARTING);
        int processingThreads = this.getChannel().getProcessingThreads();
        if (processingThreads > 1) {
            this.processingThreadIdStack = new LinkedBlockingDeque<Long>();
            for (int i = processingThreads; i >= 1; --i) {
                this.processingThreadIdStack.push(Long.valueOf(-i));
            }
        }
        this.onStart();
        this.forceQueue.set(false);
        this.updateCurrentState(DeployedState.STARTED);
    }

    public void startQueue() {
        this.stopQueue.set(false);
        if (this.isQueueEnabled() && (this.channel.getQueueHandler() == null || this.channel.getQueueHandler().canStartDestinationQueue(this))) {
            this.queue.invalidate(true, true);
            for (int i = 1; i <= this.destinationConnectorProperties.getThreadCount(); ++i) {
                DestinationQueueThread thread = new DestinationQueueThread(this);
                thread.setName("Destination Queue Thread " + i + " on " + this.channel.getName() + " (" + this.getChannelId() + "), " + this.destinationName + " (" + this.getMetaDataId() + ")");
                thread.start();
                this.queueThreads.put(thread.getId(), thread);
            }
        }
    }

    public void stopQueue() throws InterruptedException {
        this.stopQueue.set(true);
        if (MapUtils.isNotEmpty(this.queueThreads)) {
            try {
                for (DestinationQueueThread destinationQueueThread : this.queueThreads.values()) {
                    destinationQueueThread.interruptIfWaitingRetryInterval();
                }
                for (Thread thread : this.queueThreads.values()) {
                    thread.join();
                }
                this.queueThreads.clear();
            }
            finally {
                this.queue.invalidate(false, true);
            }
        }
    }

    @Override
    public void stop() throws ConnectorTaskException, InterruptedException {
        this.updateCurrentState(DeployedState.STOPPING);
        this.stopQueue.set(true);
        this.stopQueue();
        try {
            this.onStop();
            this.updateCurrentState(DeployedState.STOPPED);
        }
        catch (Throwable t) {
            Throwable cause = t;
            if (cause instanceof ConnectorTaskException) {
                cause = cause.getCause();
            }
            if (cause instanceof ExecutionException) {
                cause = cause.getCause();
            }
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            this.updateCurrentState(DeployedState.STOPPED);
            if (t instanceof ConnectorTaskException) {
                throw (ConnectorTaskException)t;
            }
            throw new ConnectorTaskException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void halt() throws ConnectorTaskException, InterruptedException {
        this.updateCurrentState(DeployedState.STOPPING);
        this.stopQueue.set(true);
        if (MapUtils.isNotEmpty(this.queueThreads)) {
            for (Thread thread : this.queueThreads.values()) {
                thread.interrupt();
            }
        }
        try {
            this.onHalt();
        }
        finally {
            if (MapUtils.isNotEmpty(this.queueThreads)) {
                try {
                    for (Thread thread : this.queueThreads.values()) {
                        thread.join();
                    }
                    this.queueThreads.clear();
                }
                finally {
                    this.queue.invalidate(false, true);
                }
            }
            this.channel.getEventDispatcher().dispatchEvent(new ConnectionStatusEvent(this.getChannelId(), this.getMetaDataId(), this.getDestinationName(), ConnectionStatusEventType.IDLE));
            this.updateCurrentState(DeployedState.STOPPED);
        }
    }

    private MessageContent getSentContent(ConnectorMessage message, ConnectorProperties connectorProperties) {
        String content = this.channel.getSerializer().serialize(connectorProperties);
        return new MessageContent(message.getChannelId(), message.getMessageId(), message.getMetaDataId(), ContentType.SENT, content, null, false);
    }

    public void transform(DonkeyDao dao, ConnectorMessage message, Status previousStatus, boolean initialAttempt) throws InterruptedException {
        try {
            this.getFilterTransformerExecutor().processConnectorMessage(message);
        }
        catch (DonkeyException e) {
            if (e instanceof MessageSerializerException) {
                Donkey.getInstance().getEventDispatcher().dispatchEvent(new ErrorEvent(this.getChannelId(), this.getMetaDataId(), message.getMessageId(), ErrorEventType.SERIALIZER, this.destinationName, null, e.getMessage(), e));
            }
            message.setStatus(Status.ERROR);
            message.setProcessingError(e.getFormattedError());
        }
        if (message.getStatus() == Status.ERROR && StringUtils.isNotBlank((CharSequence)message.getProcessingError())) {
            dao.updateErrors(message);
        }
        this.metaDataReplacer.setMetaDataMap(message, this.metaDataColumns);
        if (this.storageSettings.isStoreCustomMetaData() && !message.getMetaDataMap().isEmpty()) {
            ThreadUtils.checkInterruptedStatus();
            if (initialAttempt) {
                dao.insertMetaData(message, this.metaDataColumns);
            } else {
                dao.storeMetaData(message, this.metaDataColumns);
            }
        }
        if (this.storageSettings.isStoreTransformed() && message.getTransformed() != null) {
            ThreadUtils.checkInterruptedStatus();
            if (initialAttempt) {
                dao.insertMessageContent(message.getTransformed());
            } else {
                dao.storeMessageContent(message.getTransformed());
            }
        }
        if (message.getStatus() == Status.TRANSFORMED) {
            message.setStatus(Status.QUEUED);
            if (this.storageSettings.isStoreDestinationEncoded() && message.getEncoded() != null) {
                ThreadUtils.checkInterruptedStatus();
                if (initialAttempt) {
                    dao.insertMessageContent(message.getEncoded());
                } else {
                    dao.storeMessageContent(message.getEncoded());
                }
            }
            if (this.storageSettings.isStoreMaps()) {
                dao.updateMaps(message);
            }
        } else {
            if (message.getStatus() == Status.FILTERED) {
                message.getResponseMap().put("d" + String.valueOf(this.getMetaDataId()), new Response(Status.FILTERED, "", "Message has been filtered"));
            } else if (message.getStatus() == Status.ERROR) {
                message.getResponseMap().put("d" + String.valueOf(this.getMetaDataId()), new Response(Status.ERROR, "", "Error converting message or evaluating filter/transformer"));
            }
            dao.updateStatus(message, previousStatus);
            if (this.storageSettings.isStoreMaps()) {
                dao.updateMaps(message);
            }
        }
    }

    public void process(DonkeyDao dao, ConnectorMessage message, Status previousStatus) throws InterruptedException {
        ConnectorProperties connectorProperties = null;
        ThreadUtils.checkInterruptedStatus();
        connectorProperties = ((DestinationConnectorPropertiesInterface)((Object)this.getConnectorProperties())).clone();
        this.replaceConnectorProperties(connectorProperties, message);
        message.setSentProperties(connectorProperties);
        if (this.storageSettings.isStoreSent()) {
            ThreadUtils.checkInterruptedStatus();
            MessageContent sentContent = this.getSentContent(message, connectorProperties);
            message.setSent(sentContent);
            if (sentContent != null) {
                ThreadUtils.checkInterruptedStatus();
                dao.insertMessageContent(sentContent);
            }
        }
        if (this.willAttemptSend()) {
            int retryCount = this.destinationConnectorProperties == null ? 0 : this.destinationConnectorProperties.getRetryCount();
            int sendAttempts = 0;
            Response response = null;
            Status responseStatus = null;
            do {
                ThreadUtils.checkInterruptedStatus();
                if (sendAttempts > 0) {
                    Thread.sleep(this.destinationConnectorProperties.getRetryIntervalMillis());
                }
                response = this.handleSend(connectorProperties, message);
                message.setSendAttempts(++sendAttempts);
                response.fixStatus(this.isQueueEnabled());
            } while (((responseStatus = response.getStatus()) == Status.ERROR || responseStatus == Status.QUEUED) && sendAttempts - 1 < retryCount);
            this.afterSend(dao, message, response, previousStatus);
            if (message.getStatus() == Status.QUEUED) {
                message.setAttemptedFirst(true);
            }
        } else {
            this.updateQueuedStatus(dao, message, previousStatus);
        }
    }

    public void updateQueuedStatus(DonkeyDao dao, ConnectorMessage message, Status previousStatus) throws InterruptedException {
        message.setStatus(Status.QUEUED);
        message.getResponseMap().put("d" + String.valueOf(this.getMetaDataId()), new Response(Status.QUEUED, "", QUEUED_RESPONSE));
        if (this.storageSettings.isStoreResponseMap()) {
            dao.updateResponseMap(message);
            ThreadUtils.checkInterruptedStatus();
        }
        dao.updateStatus(message, previousStatus);
    }

    public void processPendingConnectorMessage(DonkeyDao dao, ConnectorMessage message) throws InterruptedException {
        Serializer serializer = this.channel.getSerializer();
        Response response = serializer.deserialize(message.getResponse().getContent(), Response.class);
        if (this.responseTransformerExecutor != null) {
            try {
                this.responseTransformerExecutor.runResponseTransformer(dao, message, response, this.isQueueEnabled(), this.storageSettings, serializer);
                String error = null;
                if (StringUtils.isNotBlank((CharSequence)response.getError())) {
                    error = response.getError();
                }
                message.setProcessingError(error);
                if (message.getErrorCode() > 0) {
                    dao.updateErrors(message);
                }
            }
            catch (DonkeyException e) {
                this.logger.error("Error executing response transformer for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ") on destination " + this.destinationName + ".", (Throwable)e);
                response.setStatus(Status.ERROR);
                response.setError(e.getFormattedError());
                message.setProcessingError((String)(message.getProcessingError() != null ? message.getProcessingError() + System.getProperty("line.separator") + System.getProperty("line.separator") + e.getFormattedError() : e.getFormattedError()));
                dao.updateErrors(message);
                return;
            }
            message.getResponseMap().put("d" + String.valueOf(this.getMetaDataId()), response);
            boolean wasEmpty = message.getMetaDataMap().isEmpty();
            this.channel.getSourceConnector().getMetaDataReplacer().setMetaDataMap(message, this.channel.getMetaDataColumns());
            if (this.storageSettings.isStoreCustomMetaData() && !message.getMetaDataMap().isEmpty()) {
                ThreadUtils.checkInterruptedStatus();
                if (wasEmpty) {
                    dao.insertMetaData(message, this.channel.getMetaDataColumns());
                } else {
                    dao.storeMetaData(message, this.channel.getMetaDataColumns());
                }
            }
            if (this.storageSettings.isStoreMaps()) {
                dao.updateMaps(message);
            }
        }
        this.afterResponse(dao, message, response, message.getStatus());
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response handleSend(ConnectorProperties connectorProperties, ConnectorMessage message) throws InterruptedException {
        Response response;
        message.setSendDate(Calendar.getInstance());
        long dispatcherId = this.getDispatcherId();
        try {
            message.setDispatcherId(dispatcherId);
            response = this.send(connectorProperties, message);
        }
        finally {
            if (dispatcherId < 0L) {
                this.returnProcessingThreadId(dispatcherId);
            }
        }
        if (response.isValidate() && response.getStatus() == Status.SENT && (response = this.responseValidator.validate(response, message)).getStatus() != Status.SENT) {
            this.channel.getEventDispatcher().dispatchEvent(new ErrorEvent(this.getChannelId(), this.getMetaDataId(), message.getMessageId(), ErrorEventType.RESPONSE_VALIDATION, this.getDestinationName(), connectorProperties.getName(), response.getStatusMessage(), null));
        }
        message.setResponseDate(Calendar.getInstance());
        return response;
    }

    private void afterSend(DonkeyDao dao, ConnectorMessage message, Response response, Status previousStatus) throws InterruptedException {
        Serializer serializer = this.channel.getSerializer();
        dao.updateSendAttempts(message);
        if (this.storageSettings.isStoreResponse()) {
            String responseString = serializer.serialize(response);
            MessageContent responseContent = new MessageContent(message.getChannelId(), message.getMessageId(), message.getMetaDataId(), ContentType.RESPONSE, responseString, this.responseTransformerExecutor.getInbound().getType(), false);
            ThreadUtils.checkInterruptedStatus();
            if (message.getResponse() != null) {
                dao.storeMessageContent(responseContent);
            } else {
                dao.insertMessageContent(responseContent);
            }
            message.setResponse(responseContent);
        }
        ThreadUtils.checkInterruptedStatus();
        if (this.responseTransformerExecutor.isActive(response)) {
            message.setStatus(Status.PENDING);
            dao.updateStatus(message, previousStatus);
            dao.commit(this.storageSettings.isDurable());
            previousStatus = message.getStatus();
        }
        try {
            this.responseTransformerExecutor.runResponseTransformer(dao, message, response, this.isQueueEnabled(), this.storageSettings, serializer);
            String error = null;
            if (StringUtils.isNotBlank((CharSequence)response.getError())) {
                error = response.getError();
            }
            message.setProcessingError(error);
            if (message.getErrorCode() > 0) {
                dao.updateErrors(message);
            }
        }
        catch (DonkeyException e) {
            this.logger.error("Error executing response transformer for channel " + this.channel.getName() + " (" + this.channel.getChannelId() + ") on destination " + this.destinationName + ".", (Throwable)e);
            response.setStatus(Status.ERROR);
            response.setError(e.getFormattedError());
            message.setStatus(response.getStatus());
            message.setProcessingError((String)(message.getProcessingError() != null ? message.getProcessingError() + System.getProperty("line.separator") + System.getProperty("line.separator") + e.getFormattedError() : e.getFormattedError()));
            dao.updateStatus(message, previousStatus);
            dao.updateErrors(message);
            return;
        }
        message.getResponseMap().put("d" + String.valueOf(this.getMetaDataId()), response);
        boolean wasEmpty = message.getMetaDataMap().isEmpty();
        this.channel.getSourceConnector().getMetaDataReplacer().setMetaDataMap(message, this.channel.getMetaDataColumns());
        if (this.storageSettings.isStoreCustomMetaData() && !message.getMetaDataMap().isEmpty()) {
            ThreadUtils.checkInterruptedStatus();
            if (wasEmpty) {
                dao.insertMetaData(message, this.channel.getMetaDataColumns());
            } else {
                dao.storeMetaData(message, this.channel.getMetaDataColumns());
            }
        }
        if (this.storageSettings.isStoreMaps()) {
            dao.updateMaps(message);
        }
        ThreadUtils.checkInterruptedStatus();
        this.afterResponse(dao, message, response, previousStatus);
    }

    private void afterResponse(DonkeyDao dao, ConnectorMessage connectorMessage, Response response, Status previousStatus) {
        connectorMessage.setStatus(response.getStatus());
        dao.updateStatus(connectorMessage, previousStatus);
        previousStatus = connectorMessage.getStatus();
    }

    public static class DestinationQueueThread
    extends Thread {
        private AtomicBoolean waitingRetryInterval = new AtomicBoolean(false);

        public DestinationQueueThread(Runnable runnable) {
            super(runnable);
        }

        public AtomicBoolean getWaitingRetryInterval() {
            return this.waitingRetryInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptIfWaitingRetryInterval() {
            AtomicBoolean atomicBoolean = this.waitingRetryInterval;
            synchronized (atomicBoolean) {
                if (this.waitingRetryInterval.get()) {
                    this.interrupt();
                }
            }
        }
    }
}

