/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.MetaDataColumnException;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaDataReplacer {
    private Logger logger = LogManager.getLogger(this.getClass());

    public void setMetaDataMap(ConnectorMessage connectorMessage, List<MetaDataColumn> metaDataColumns) {
        for (MetaDataColumn column : metaDataColumns) {
            Object value;
            if (!StringUtils.isNotEmpty((CharSequence)column.getMappingName()) || (value = this.getMetaDataValue(connectorMessage, column)) == null) continue;
            try {
                connectorMessage.getMetaDataMap().put(column.getName(), column.getType().castValue(value));
            }
            catch (MetaDataColumnException e) {
                this.logger.warn("Could not cast value '" + String.valueOf(value) + "' to " + column.getType().toString(), (Throwable)e);
            }
        }
    }

    protected Object getMetaDataValue(ConnectorMessage connectorMessage, MetaDataColumn column) {
        Object value = null;
        if (connectorMessage.getConnectorMap().containsKey(column.getMappingName())) {
            value = connectorMessage.getConnectorMap().get(column.getMappingName());
        } else if (connectorMessage.getChannelMap().containsKey(column.getMappingName())) {
            value = connectorMessage.getChannelMap().get(column.getMappingName());
        } else if (connectorMessage.getSourceMap().containsKey(column.getMappingName())) {
            value = connectorMessage.getSourceMap().get(column.getMappingName());
        }
        return value;
    }
}

