/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.channel.PollConnectorProperties;
import com.mirth.connect.donkey.model.channel.PollConnectorPropertiesInterface;
import com.mirth.connect.donkey.server.ConnectorTaskException;
import com.mirth.connect.donkey.server.channel.PollConnectorJob;
import com.mirth.connect.donkey.server.channel.PollConnectorJobFactory;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.util.PollConnectorJobHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public abstract class PollConnector
extends SourceConnector {
    private PollConnectorJobHandler handler;
    private AtomicBoolean terminated = new AtomicBoolean(true);
    private JobDetail job;
    private Scheduler scheduler;

    @Override
    public void start() throws ConnectorTaskException, InterruptedException {
        super.start();
        this.terminated.set(false);
        PollConnectorProperties pollConnectorProperties = ((PollConnectorPropertiesInterface)((Object)this.getConnectorProperties())).getPollConnectorProperties();
        this.handler = new PollConnectorJobHandler(pollConnectorProperties, this.getChannelId(), true);
        try {
            this.handler.configureJob(PollConnectorJob.class, new PollConnectorJobFactory(this), "PollConnector");
            this.handler.scheduleJob(true);
            this.job = this.handler.getJob();
            this.scheduler = this.handler.getScheduler();
        }
        catch (Exception e) {
            throw new ConnectorTaskException(e);
        }
    }

    @Override
    public void stop() throws ConnectorTaskException, InterruptedException {
        this.terminated.set(true);
        if (this.scheduler != null) {
            try {
                this.scheduler.shutdown(true);
            }
            catch (SchedulerException e) {
                throw new ConnectorTaskException(e);
            }
        }
        super.stop();
    }

    @Override
    public void halt() throws ConnectorTaskException, InterruptedException {
        this.terminated.set(true);
        if (this.scheduler != null) {
            try {
                this.scheduler.interrupt(this.job.getKey());
            }
            catch (Exception e) {
                throw new ConnectorTaskException(e);
            }
        }
        super.halt();
    }

    public boolean isTerminated() {
        return this.terminated.get();
    }

    protected abstract void poll() throws InterruptedException;
}

