/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.channel;

import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.message.DataType;
import java.util.HashMap;
import java.util.Map;

public class ResponseSelector {
    private static Map<Status, Integer> statusPrecedenceMap = new HashMap<Status, Integer>();
    private DataType dataType;
    private int numDestinations;
    private String respondFromName;

    public ResponseSelector(DataType dataType) {
        this.dataType = dataType;
    }

    void setNumDestinations(int numDestinations) {
        this.numDestinations = numDestinations;
    }

    public String getRespondFromName() {
        return this.respondFromName;
    }

    public void setRespondFromName(String respondFromName) {
        this.respondFromName = respondFromName;
    }

    public boolean canRespond() {
        return this.respondFromName != null && !this.respondFromName.equals("None");
    }

    public Response getResponse(ConnectorMessage sourceMessage, Message message) throws Exception {
        Object responseObject;
        if (this.respondFromName.equals("Auto-generate (Before processing)")) {
            return this.dataType.getAutoResponder().getResponse(Status.RECEIVED, sourceMessage.getRaw().getContent(), sourceMessage);
        }
        if (this.respondFromName.equals("Auto-generate (After source transformer)")) {
            return this.dataType.getAutoResponder().getResponse(sourceMessage.getStatus(), sourceMessage.getRaw().getContent(), sourceMessage);
        }
        if (this.respondFromName.equals("Auto-generate (Destinations completed)")) {
            Status status = Status.SENT;
            if (message.getConnectorMessages().size() - 1 < this.numDestinations) {
                status = Status.ERROR;
            }
            Integer highestPrecedence = null;
            for (ConnectorMessage connectorMessage : message.getConnectorMessages().values()) {
                Integer precedence;
                if (connectorMessage.getMetaDataId() <= 0 || (precedence = statusPrecedenceMap.get((Object)connectorMessage.getStatus())) == null || highestPrecedence != null && precedence <= highestPrecedence) continue;
                status = connectorMessage.getStatus();
                highestPrecedence = precedence;
            }
            return this.dataType.getAutoResponder().getResponse(status, sourceMessage.getRaw().getContent(), message.getMergedConnectorMessage());
        }
        if (this.respondFromName != null && (responseObject = message.getConnectorMessages().get(0).getResponseMap().get(this.respondFromName)) != null) {
            if (responseObject instanceof Response) {
                return (Response)responseObject;
            }
            return new Response(Status.SENT, responseObject.toString());
        }
        return null;
    }

    static {
        int i = SourceConnectorProperties.RESPONSE_STATUS_PRECEDENCE.length;
        for (Status status : SourceConnectorProperties.RESPONSE_STATUS_PRECEDENCE) {
            statusPrecedenceMap.put(status, i--);
        }
    }
}

