/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.controllers;

import com.google.inject.Inject;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoException;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ChannelController {
    @Inject
    private static ChannelController instance;
    private Statistics currentStats;
    private Statistics totalStats;
    private Donkey donkey = Donkey.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelController getInstance() {
        Class<ChannelController> clazz = ChannelController.class;
        synchronized (ChannelController.class) {
            if (instance == null) {
                instance = new ChannelController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ChannelController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannel(String channelId) {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            dao.removeChannel(channelId);
            dao.commit();
            commitSuccess = true;
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    public void loadStatistics(String serverId) {
        try (DonkeyDao dao = this.donkey.getDaoFactory().getDao();){
            this.currentStats = dao.getChannelStatistics(serverId);
            this.totalStats = dao.getChannelTotalStatistics(serverId);
        }
    }

    public Statistics getStatistics() {
        return this.currentStats;
    }

    public Statistics getTotalStatistics() {
        return this.totalStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getStatisticsFromStorage(String serverId) {
        try (DonkeyDao dao = this.donkey.getReadOnlyDaoFactory().getDao();){
            Statistics statistics = dao.getChannelStatistics(serverId);
            return statistics;
        }
    }

    public List<Ports> getPortsInUse() {
        try (DonkeyDao dao = this.donkey.getReadOnlyDaoFactory().getDao();){
            List<Ports> list = dao.getPortsInUse();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getTotalStatisticsFromStorage(String serverId) {
        try (DonkeyDao dao = this.donkey.getReadOnlyDaoFactory().getDao();){
            Statistics statistics = dao.getChannelTotalStatistics(serverId);
            return statistics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectorMessageCount(String channelId, String serverId, int metaDataId, Status status) {
        try (DonkeyDao dao = this.donkey.getReadOnlyDaoFactory().getDao();){
            int n = dao.getConnectorMessageCount(channelId, serverId, metaDataId, status);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatistics(Map<String, List<Integer>> channelConnectorMap, Set<Status> statuses) {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            for (Map.Entry<String, List<Integer>> entry : channelConnectorMap.entrySet()) {
                String channelId = entry.getKey();
                List<Integer> metaDataIds = entry.getValue();
                for (Integer metaDataId : metaDataIds) {
                    commitSuccess = false;
                    dao.resetStatistics(channelId, metaDataId, statuses);
                    dao.commit();
                    commitSuccess = true;
                }
            }
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAllStatistics() {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            for (String channelId : dao.getLocalChannelIds().keySet()) {
                dao.resetAllStatistics(channelId);
                dao.commit();
                commitSuccess = true;
            }
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    public Long getLocalChannelId(String channelId) {
        return this.getLocalChannelId(channelId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLocalChannelId(String channelId, boolean readOnly) {
        int attemptsRemaining = 3;
        while (true) {
            try {
                Long localChannelId = null;
                DonkeyDaoFactory daoFactory = readOnly ? this.donkey.getReadOnlyDaoFactory() : this.donkey.getDaoFactory();
                try (DonkeyDao dao = daoFactory.getDao();){
                    localChannelId = dao.getLocalChannelIds().get(channelId);
                }
                if (localChannelId == null) {
                    localChannelId = this.createChannel(channelId);
                }
                return localChannelId;
            }
            catch (DonkeyDaoException e) {
                if (e.getCause() instanceof SQLException) {
                    SQLException sqlException = (SQLException)e.getCause();
                    if (--attemptsRemaining == 0 || !StringUtils.equals((CharSequence)sqlException.getSQLState(), (CharSequence)"23000") && !StringUtils.equals((CharSequence)sqlException.getSQLState(), (CharSequence)"23505") && !StringUtils.containsIgnoreCase((CharSequence)sqlException.getMessage(), (CharSequence)"duplicate") && !StringUtils.containsIgnoreCase((CharSequence)sqlException.getMessage(), (CharSequence)"unique constraint")) {
                        throw e;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public void initChannelStorage(String channelId) {
        this.getLocalChannelId(channelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean channelExists(String channelId) {
        try (DonkeyDao dao = this.donkey.getDaoFactory().getDao();){
            boolean bl = dao.getLocalChannelIds().get(channelId) != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllMessages(String channelId) {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            if (dao.getLocalChannelIds().get(channelId) != null) {
                dao.deleteAllMessages(channelId);
            }
            dao.commit();
            commitSuccess = true;
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long createChannel(String channelId) {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            Long localChannelId = dao.selectMaxLocalChannelId();
            if (localChannelId == null) {
                localChannelId = 1L;
            } else {
                Long l = localChannelId;
                localChannelId = localChannelId + 1L;
            }
            dao.createChannel(channelId, localChannelId);
            dao.commit();
            commitSuccess = true;
            long l = localChannelId;
            return l;
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }
}

