/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.controllers;

import com.google.inject.Inject;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.controllers.UnsupportedDataTypeException;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.util.Base64Util;
import com.mirth.connect.donkey.util.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class MessageController {
    @Inject
    private static MessageController instance;
    private Donkey donkey = Donkey.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageController getInstance() {
        Class<MessageController> clazz = MessageController.class;
        synchronized (MessageController.class) {
            if (instance == null) {
                instance = new MessageController();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MessageController() {
    }

    public Attachment createAttachment(Object data, String type) throws UnsupportedDataTypeException {
        return this.createAttachment(data, type, false);
    }

    public Attachment createAttachment(Object data, String type, boolean base64Encode) throws UnsupportedDataTypeException {
        byte[] byteData;
        if (data instanceof byte[]) {
            byteData = (byte[])data;
        } else if (data instanceof String) {
            byteData = StringUtil.getBytesUncheckedChunked((String)data, "UTF-8");
        } else {
            throw new UnsupportedDataTypeException("Attachment can be of type String or byte[]");
        }
        if (base64Encode) {
            try {
                byteData = Base64Util.encodeBase64(byteData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Attachment attachment = new Attachment();
        attachment.setId(UUID.randomUUID().toString());
        attachment.setContent(byteData);
        attachment.setType(type);
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAttachment(Attachment attachment, String channelId, Long messageId) {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            dao.insertMessageAttachment(channelId, messageId, attachment);
            dao.commit();
            commitSuccess = true;
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAttachment(Attachment attachment, String channelId, Long messageId) {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            dao.updateMessageAttachment(channelId, messageId, attachment);
            dao.commit();
            commitSuccess = true;
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    public boolean isMessageCompleted(Message message) {
        if (MapUtils.isEmpty(message.getConnectorMessages())) {
            return false;
        }
        for (Map.Entry<Integer, ConnectorMessage> connectorMessageEntry : message.getConnectorMessages().entrySet()) {
            ConnectorMessage connectorMessage = connectorMessageEntry.getValue();
            if (connectorMessage.getStatus().isCompleted()) continue;
            return false;
        }
        return true;
    }

    public boolean isMessageCompleted(Set<Status> statuses) {
        if (CollectionUtils.isEmpty(statuses)) {
            return false;
        }
        for (Status status : statuses) {
            if (status.isCompleted()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessages(String channelId, Map<Long, Set<Integer>> messages) {
        DonkeyDao dao = this.donkey.getDaoFactory().getDao();
        boolean commitSuccess = false;
        try {
            for (Map.Entry<Long, Set<Integer>> messageEntry : messages.entrySet()) {
                Long messageId = messageEntry.getKey();
                Set<Integer> metaDataIds = messageEntry.getValue();
                if (metaDataIds == null) {
                    dao.deleteMessage(channelId, messageId);
                    continue;
                }
                dao.deleteConnectorMessages(channelId, messageId, metaDataIds);
            }
            dao.commit();
            commitSuccess = true;
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }
}

