/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data;

import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.controllers.MessageTrendsController;
import com.mirth.connect.donkey.server.data.ChannelDoesNotExistException;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DonkeyStatisticsUpdater
extends Thread
implements StatisticsUpdater {
    public static final int DEFAULT_UPDATE_INTERVAL = 1000;
    private DonkeyDaoFactory daoFactory;
    private int updateInterval;
    private Statistics statistics = new Statistics(false, true);
    private MessageTrendsController messageTrendsController;
    private Logger logger = LogManager.getLogger(this.getClass());

    public DonkeyStatisticsUpdater(DonkeyDaoFactory daoFactory, int updateInterval) {
        this.setDaoFactory(daoFactory);
        if (updateInterval <= 0) {
            updateInterval = 1000;
        }
        this.updateInterval = updateInterval;
        this.setName("Statistics Updater Thread");
        this.messageTrendsController = new MessageTrendsController();
        try {
            Class<?> clazz = Class.forName("com.mirth.connect.plugins.messagetrends.server.controller.TimeSeriesStatisticsController");
            Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.messageTrendsController = (MessageTrendsController)instance;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setDaoFactory(DonkeyDaoFactory daoFactory) {
        this.daoFactory = daoFactory;
        if (daoFactory != null) {
            daoFactory.setStatisticsUpdater(this);
        }
    }

    @Override
    public void run() {
        boolean done = false;
        while (!done) {
            try {
                Thread.sleep(this.updateInterval);
                this.commit();
            }
            catch (InterruptedException e) {
                try {
                    this.commit();
                }
                catch (InterruptedException e2) {
                    this.logger.error("Unable to update statistics before stopping engine.", (Throwable)e);
                }
                Thread.currentThread().interrupt();
                done = true;
            }
        }
    }

    public void shutdown() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() throws InterruptedException {
        if (!this.statistics.isEmpty() && this.daoFactory != null) {
            Statistics tempStats = new Statistics(false, true);
            Map<String, Map<Integer, Map<Status, Long>>> stats = this.statistics.getStats();
            tempStats.update(stats);
            DonkeyDao dao = this.daoFactory.getDao();
            boolean commitSuccess = false;
            try {
                dao.addChannelStatistics(tempStats);
                dao.commit();
                commitSuccess = true;
                try {
                    this.messageTrendsController.writeTimeseries(stats);
                }
                catch (Throwable t) {
                    this.logger.warn("Message Trends write failed (non-fatal).", t);
                }
                for (Map<Integer, Map<Status, Long>> channelMap : stats.values()) {
                    for (Map<Status, Long> connectorMap : channelMap.values()) {
                        for (Map.Entry<Status, Long> entry : connectorMap.entrySet()) {
                            entry.setValue(-entry.getValue().longValue());
                        }
                    }
                }
                this.statistics.update(stats);
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                if (t instanceof ChannelDoesNotExistException) {
                    ChannelDoesNotExistException e = (ChannelDoesNotExistException)t;
                    this.logger.debug("Unable to update statistics.", (Throwable)e);
                    for (String channelId : e.getChannelIds()) {
                        this.statistics.remove(channelId);
                    }
                } else {
                    this.logger.error("Unable to update statistics.", t);
                }
            }
            finally {
                if (dao != null) {
                    if (!commitSuccess) {
                        try {
                            dao.rollback();
                        }
                        catch (Exception t) {}
                    }
                    dao.close();
                }
            }
        }
    }

    @Override
    public void update(Statistics statistics) {
        if (!statistics.isEmpty()) {
            this.statistics.update(statistics);
        }
    }
}

