/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.buffered;

import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.Ports;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import com.mirth.connect.donkey.server.data.buffered.DaoTask;
import com.mirth.connect.donkey.server.data.buffered.DaoTaskType;
import com.mirth.connect.donkey.util.SerializerProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferedDao
implements DonkeyDao {
    private DonkeyDaoFactory daoFactory;
    private SerializerProvider serializerProvider;
    private boolean encryptMessageContent;
    private boolean encryptAttachments;
    private boolean encryptCustomMetaData;
    private boolean decryptData;
    private StatisticsUpdater statisticsUpdater;
    private Queue<DaoTask> tasks = new LinkedList<DaoTask>();
    private boolean closed = false;
    private Logger logger = LogManager.getLogger(this.getClass());

    protected BufferedDao(DonkeyDaoFactory daoFactory, SerializerProvider serializerProvider, boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData, boolean decryptData, StatisticsUpdater statisticsUpdater) {
        this.daoFactory = daoFactory;
        this.serializerProvider = serializerProvider;
        this.encryptMessageContent = encryptMessageContent;
        this.encryptAttachments = encryptAttachments;
        this.encryptCustomMetaData = encryptCustomMetaData;
        this.decryptData = decryptData;
        this.statisticsUpdater = statisticsUpdater;
    }

    @Override
    public void setEncryptData(boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData) {
        this.encryptMessageContent = encryptMessageContent;
        this.encryptAttachments = encryptAttachments;
        this.encryptCustomMetaData = encryptCustomMetaData;
    }

    @Override
    public void setDecryptData(boolean decryptData) {
        this.decryptData = decryptData;
    }

    @Override
    public void setStatisticsUpdater(StatisticsUpdater statisticsUpdater) {
        this.statisticsUpdater = statisticsUpdater;
    }

    @Override
    public void commit() {
        this.commit(null);
    }

    @Override
    public void commit(boolean durable) {
        this.commit(new Boolean(durable));
    }

    private void commit(Boolean durable) {
        if (this.closed) {
            this.logger.error("Failed to commit, the storage buffer has been closed");
            return;
        }
        if (this.tasks.isEmpty()) {
            return;
        }
        this.executeTasks(durable);
    }

    private DonkeyDao getDelegateDao() {
        DonkeyDao dao = this.daoFactory.getDao(this.serializerProvider);
        dao.setEncryptData(this.encryptMessageContent, this.encryptAttachments, this.encryptCustomMetaData);
        dao.setDecryptData(this.decryptData);
        dao.setStatisticsUpdater(this.statisticsUpdater);
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTasks(Boolean durable) {
        DonkeyDao dao = this.getDelegateDao();
        boolean commitSuccess = false;
        try {
            while (!this.tasks.isEmpty()) {
                DaoTask task = this.tasks.poll();
                Object[] p = task.getParameters();
                switch (task.getTaskType()) {
                    case INSERT_MESSAGE: {
                        dao.insertMessage((Message)p[0]);
                        break;
                    }
                    case INSERT_CONNECTOR_MESSAGE: {
                        dao.insertConnectorMessage((ConnectorMessage)p[0], (Boolean)p[1], (Boolean)p[2]);
                        break;
                    }
                    case INSERT_MESSAGE_CONTENT: {
                        dao.insertMessageContent((MessageContent)p[0]);
                        break;
                    }
                    case BATCH_INSERT_MESSAGE_CONTENT: {
                        dao.batchInsertMessageContent((MessageContent)p[0]);
                        break;
                    }
                    case EXECUTE_BATCH_INSERT_MESSAGE_CONTENT: {
                        dao.executeBatchInsertMessageContent((String)p[0]);
                        break;
                    }
                    case INSERT_MESSAGE_ATTACHMENT: {
                        dao.insertMessageAttachment((String)p[0], (Long)p[1], (Attachment)p[2]);
                        break;
                    }
                    case UPDATE_MESSAGE_ATTACHMENT: {
                        dao.updateMessageAttachment((String)p[0], (Long)p[1], (Attachment)p[2]);
                        break;
                    }
                    case INSERT_META_DATA: {
                        dao.insertMetaData((ConnectorMessage)p[0], (List)p[1]);
                        break;
                    }
                    case STORE_META_DATA: {
                        dao.storeMetaData((ConnectorMessage)p[0], (List)p[1]);
                        break;
                    }
                    case STORE_MESSAGE_CONTENT: {
                        dao.storeMessageContent((MessageContent)p[0]);
                        break;
                    }
                    case STORE_CHANNEL_STATISTICS: {
                        dao.addChannelStatistics((Statistics)p[0]);
                        break;
                    }
                    case UPDATE_SEND_ATTEMPTS: {
                        dao.updateSendAttempts((ConnectorMessage)p[0]);
                        break;
                    }
                    case UPDATE_STATUS: {
                        dao.updateStatus((ConnectorMessage)p[0], (Status)((Object)p[1]));
                        break;
                    }
                    case UPDATE_ERRORS: {
                        dao.updateErrors((ConnectorMessage)p[0]);
                        break;
                    }
                    case UPDATE_MAPS: {
                        dao.updateMaps((ConnectorMessage)p[0]);
                        break;
                    }
                    case UPDATE_SOURCE_MAP: {
                        dao.updateSourceMap((ConnectorMessage)p[0]);
                        break;
                    }
                    case UPDATE_RESPONSE_MAP: {
                        dao.updateResponseMap((ConnectorMessage)p[0]);
                        break;
                    }
                    case MARK_AS_PROCESSED: {
                        dao.markAsProcessed((String)p[0], (Long)p[1]);
                        break;
                    }
                    case RESET_MESSAGE: {
                        dao.resetMessage((String)p[0], (Long)p[1]);
                        break;
                    }
                    case DELETE_MESSAGE: {
                        dao.deleteMessage((String)p[0], (Long)p[1]);
                        break;
                    }
                    case DELETE_CONNECTOR_MESSAGES: {
                        dao.deleteConnectorMessages((String)p[0], (Long)p[1], (Set)p[2]);
                        break;
                    }
                    case DELETE_MESSAGE_STATISTICS: {
                        dao.deleteMessageStatistics((String)p[0], (Long)p[1], (Set)p[2]);
                        break;
                    }
                    case DELETE_ALL_MESSAGES: {
                        dao.deleteAllMessages((String)p[0]);
                        break;
                    }
                    case DELETE_MESSAGE_CONTENT: {
                        dao.deleteMessageContent((String)p[0], (Long)p[1]);
                        break;
                    }
                    case DELETE_MESSAGE_CONTENT_BY_META_DATA_IDS: {
                        dao.deleteMessageContentByMetaDataIds((String)p[0], (Long)p[1], (Set)p[2]);
                        break;
                    }
                    case DELETE_MESSAGE_ATTACHMENTS: {
                        dao.deleteMessageAttachments((String)p[0], (Long)p[1]);
                        break;
                    }
                    case CREATE_CHANNEL: {
                        dao.createChannel((String)p[0], (Long)p[1]);
                        break;
                    }
                    case REMOVE_CHANNEL: {
                        dao.removeChannel((String)p[0]);
                        break;
                    }
                    case ADD_META_DATA_COLUMN: {
                        dao.addMetaDataColumn((String)p[0], (MetaDataColumn)p[1]);
                        break;
                    }
                    case REMOVE_META_DATA_COLUMN: {
                        dao.removeMetaDataColumn((String)p[0], (String)p[1]);
                        break;
                    }
                    case RESET_STATISTICS: {
                        dao.resetStatistics((String)p[0], (Integer)p[1], (Set)p[2]);
                        break;
                    }
                    case RESET_ALL_STATISTICS: {
                        dao.resetAllStatistics((String)p[0]);
                        break;
                    }
                    case GET_PORTS_IN_USE: {
                        dao.getPortsInUse();
                    }
                }
            }
            if (durable == null) {
                dao.commit();
                commitSuccess = true;
            } else {
                dao.commit(durable);
                commitSuccess = true;
            }
        }
        finally {
            if (dao != null) {
                if (!commitSuccess) {
                    try {
                        dao.rollback();
                    }
                    catch (Exception exception) {}
                }
                dao.close();
            }
        }
    }

    @Override
    public void rollback() {
        this.tasks.clear();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void insertMessage(Message message) {
        this.tasks.add(new DaoTask(DaoTaskType.INSERT_MESSAGE, new Object[]{message}));
    }

    @Override
    public void insertConnectorMessage(ConnectorMessage connectorMessage, boolean storeMaps, boolean updateStats) {
        this.tasks.add(new DaoTask(DaoTaskType.INSERT_CONNECTOR_MESSAGE, new Object[]{connectorMessage, storeMaps, updateStats}));
    }

    @Override
    public void insertMessageContent(MessageContent messageContent) {
        this.tasks.add(new DaoTask(DaoTaskType.INSERT_MESSAGE_CONTENT, new Object[]{messageContent}));
    }

    @Override
    public void batchInsertMessageContent(MessageContent messageContent) {
        this.tasks.add(new DaoTask(DaoTaskType.BATCH_INSERT_MESSAGE_CONTENT, new Object[]{messageContent}));
    }

    @Override
    public void executeBatchInsertMessageContent(String channelId) {
        this.tasks.add(new DaoTask(DaoTaskType.EXECUTE_BATCH_INSERT_MESSAGE_CONTENT, new Object[]{channelId}));
    }

    @Override
    public void insertMessageAttachment(String channelId, long messageId, Attachment attachment) {
        this.tasks.add(new DaoTask(DaoTaskType.INSERT_MESSAGE_ATTACHMENT, new Object[]{channelId, messageId, attachment}));
    }

    @Override
    public void updateMessageAttachment(String channelId, long messageId, Attachment attachment) {
        this.tasks.add(new DaoTask(DaoTaskType.UPDATE_MESSAGE_ATTACHMENT, new Object[]{channelId, messageId, attachment}));
    }

    @Override
    public void insertMetaData(ConnectorMessage connectorMessage, List<MetaDataColumn> metaDataColumns) {
        this.tasks.add(new DaoTask(DaoTaskType.INSERT_META_DATA, new Object[]{connectorMessage, metaDataColumns}));
    }

    @Override
    public void storeMetaData(ConnectorMessage connectorMessage, List<MetaDataColumn> metaDataColumns) {
        this.tasks.add(new DaoTask(DaoTaskType.STORE_META_DATA, new Object[]{connectorMessage, metaDataColumns}));
    }

    @Override
    public void storeMessageContent(MessageContent messageContent) {
        this.tasks.add(new DaoTask(DaoTaskType.STORE_MESSAGE_CONTENT, new Object[]{messageContent}));
    }

    @Override
    public void addChannelStatistics(Statistics statistics) {
        this.tasks.add(new DaoTask(DaoTaskType.STORE_CHANNEL_STATISTICS, new Object[]{statistics}));
    }

    @Override
    public void updateSendAttempts(ConnectorMessage connectorMessage) {
        this.tasks.add(new DaoTask(DaoTaskType.UPDATE_SEND_ATTEMPTS, new Object[]{connectorMessage}));
    }

    @Override
    public void updateStatus(ConnectorMessage connectorMessage, Status previousStatus) {
        this.tasks.add(new DaoTask(DaoTaskType.UPDATE_STATUS, new Object[]{connectorMessage, previousStatus}));
    }

    @Override
    public void updateErrors(ConnectorMessage connectorMessage) {
        this.tasks.add(new DaoTask(DaoTaskType.UPDATE_ERRORS, new Object[]{connectorMessage}));
    }

    @Override
    public void updateMaps(ConnectorMessage connectorMessage) {
        this.tasks.add(new DaoTask(DaoTaskType.UPDATE_MAPS, new Object[]{connectorMessage}));
    }

    @Override
    public void updateSourceMap(ConnectorMessage connectorMessage) {
        this.tasks.add(new DaoTask(DaoTaskType.UPDATE_SOURCE_MAP, new Object[]{connectorMessage}));
    }

    @Override
    public void updateResponseMap(ConnectorMessage connectorMessage) {
        this.tasks.add(new DaoTask(DaoTaskType.UPDATE_RESPONSE_MAP, new Object[]{connectorMessage}));
    }

    @Override
    public void markAsProcessed(String channelId, long messageId) {
        this.tasks.add(new DaoTask(DaoTaskType.MARK_AS_PROCESSED, new Object[]{channelId, messageId}));
    }

    @Override
    public void resetMessage(String channelId, long messageId) {
        this.tasks.add(new DaoTask(DaoTaskType.RESET_MESSAGE, new Object[]{channelId, messageId}));
    }

    @Override
    public void deleteMessage(String channelId, long messageId) {
        this.tasks.add(new DaoTask(DaoTaskType.DELETE_MESSAGE, new Object[]{channelId, messageId}));
    }

    @Override
    public void deleteConnectorMessages(String channelId, long messageId, Set<Integer> metaDataIds) {
        this.tasks.add(new DaoTask(DaoTaskType.DELETE_CONNECTOR_MESSAGES, new Object[]{channelId, messageId, metaDataIds}));
    }

    @Override
    public void deleteMessageStatistics(String channelId, long messageId, Set<Integer> metaDataIds) {
        this.tasks.add(new DaoTask(DaoTaskType.DELETE_MESSAGE_STATISTICS, new Object[]{channelId, messageId, metaDataIds}));
    }

    @Override
    public void deleteAllMessages(String channelId) {
        this.tasks.add(new DaoTask(DaoTaskType.DELETE_ALL_MESSAGES, new Object[]{channelId}));
    }

    @Override
    public void deleteMessageContent(String channelId, long messageId) {
        this.tasks.add(new DaoTask(DaoTaskType.DELETE_MESSAGE_CONTENT, new Object[]{channelId, messageId}));
    }

    @Override
    public void deleteMessageContentByMetaDataIds(String channelId, long messageId, Set<Integer> metaDataIds) {
        this.tasks.add(new DaoTask(DaoTaskType.DELETE_MESSAGE_CONTENT_BY_META_DATA_IDS, new Object[]{channelId, messageId, metaDataIds}));
    }

    @Override
    public void deleteMessageAttachments(String channelId, long messageId) {
        this.tasks.add(new DaoTask(DaoTaskType.DELETE_MESSAGE_ATTACHMENTS, new Object[]{channelId, messageId}));
    }

    @Override
    public void createChannel(String channelId, long localChannelId) {
        this.tasks.add(new DaoTask(DaoTaskType.CREATE_CHANNEL, new Object[]{channelId, localChannelId}));
    }

    @Override
    public void checkAndCreateChannelTables() {
        this.tasks.add(new DaoTask(DaoTaskType.CHECK_CHANNEL_TABLES, new Object[0]));
    }

    @Override
    public void removeChannel(String channelId) {
        this.tasks.add(new DaoTask(DaoTaskType.REMOVE_CHANNEL, new Object[]{channelId}));
    }

    @Override
    public void addMetaDataColumn(String channelId, MetaDataColumn metaDataColumn) {
        this.tasks.add(new DaoTask(DaoTaskType.ADD_META_DATA_COLUMN, new Object[]{channelId, metaDataColumn}));
    }

    @Override
    public void removeMetaDataColumn(String channelId, String columnName) {
        this.tasks.add(new DaoTask(DaoTaskType.REMOVE_META_DATA_COLUMN, new Object[]{channelId, columnName}));
    }

    @Override
    public void resetStatistics(String channelId, Integer metaDataId, Set<Status> statuses) {
        this.tasks.add(new DaoTask(DaoTaskType.RESET_STATISTICS, new Object[]{channelId, metaDataId, statuses}));
    }

    @Override
    public void resetAllStatistics(String channelId) {
        this.tasks.add(new DaoTask(DaoTaskType.RESET_ALL_STATISTICS, new Object[]{channelId}));
    }

    @Override
    public boolean initTableStructure() {
        try (DonkeyDao dao = this.getDelegateDao();){
            boolean bl = dao.initTableStructure();
            return bl;
        }
    }

    @Override
    public Map<String, Long> getLocalChannelIds() {
        try (DonkeyDao dao = this.getDelegateDao();){
            Map<String, Long> map = dao.getLocalChannelIds();
            return map;
        }
    }

    @Override
    public Long selectMaxLocalChannelId() {
        try (DonkeyDao dao = this.getDelegateDao();){
            Long l = dao.selectMaxLocalChannelId();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxMessageId(String channelId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            long l = dao.getMaxMessageId(channelId);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMinMessageId(String channelId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            long l = dao.getMinMessageId(channelId);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextMessageId(String channelId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            long id = dao.getNextMessageId(channelId);
            dao.commit();
            long l = id;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Attachment> getMessageAttachment(String channelId, long messageId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<Attachment> list = dao.getMessageAttachment(channelId, messageId);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attachment getMessageAttachment(String channelId, String attachmentId, Long messageId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            Attachment attachment = dao.getMessageAttachment(channelId, attachmentId, messageId);
            return attachment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getPendingConnectorMessages(String channelId, String serverId, int limit, Long minMessageId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<Message> list = dao.getPendingConnectorMessages(channelId, serverId, limit, minMessageId);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getMessages(String channelId, List<Long> messageIds) {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<Message> list = dao.getMessages(channelId, messageIds);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectorMessage> getConnectorMessages(String channelId, String serverId, int metaDataId, Status status, int offset, int limit, Long minMessageId, Long maxMessageId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<ConnectorMessage> list = dao.getConnectorMessages(channelId, serverId, metaDataId, status, offset, limit, minMessageId, maxMessageId);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConnectorMessage> getConnectorMessages(String channelId, long messageId, Set<Integer> metaDataIds, boolean includeContent) {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<ConnectorMessage> list = dao.getConnectorMessages(channelId, messageId, metaDataIds, includeContent);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, ConnectorMessage> getConnectorMessages(String channelId, long messageId, List<Integer> metaDataIds) {
        try (DonkeyDao dao = this.getDelegateDao();){
            Map<Integer, ConnectorMessage> map = dao.getConnectorMessages(channelId, messageId, metaDataIds);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectorMessageCount(String channelId, String serverId, int metaDataId, Status status) {
        try (DonkeyDao dao = this.getDelegateDao();){
            int n = dao.getConnectorMessageCount(channelId, serverId, metaDataId, status);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getConnectorMessageMaxMessageId(String channelId, String serverId, int metaDataId, Status status) {
        try (DonkeyDao dao = this.getDelegateDao();){
            long l = dao.getConnectorMessageMaxMessageId(channelId, serverId, metaDataId, status);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, Status> getConnectorMessageStatuses(String channelId, long messageId, boolean checkProcessed) {
        try (DonkeyDao dao = this.getDelegateDao();){
            Map<Integer, Status> map = dao.getConnectorMessageStatuses(channelId, messageId, checkProcessed);
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getUnfinishedMessages(String channelId, String serverId, int limit, Long minMessageId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<Message> list = dao.getUnfinishedMessages(channelId, serverId, limit, minMessageId);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MetaDataColumn> getMetaDataColumns(String channelId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<MetaDataColumn> list = dao.getMetaDataColumns(channelId);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics getChannelStatistics(String serverId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            Statistics statistics = dao.getChannelStatistics(serverId);
            return statistics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics getChannelTotalStatistics(String serverId) {
        try (DonkeyDao dao = this.getDelegateDao();){
            Statistics statistics = dao.getChannelTotalStatistics(serverId);
            return statistics;
        }
    }

    @Override
    public List<Ports> getPortsInUse() {
        try (DonkeyDao dao = this.getDelegateDao();){
            List<Ports> list = dao.getPortsInUse();
            return list;
        }
    }
}

