/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.data.jdbc.ConnectionPool;
import com.mirth.connect.donkey.server.data.jdbc.PooledConnection;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class HikariConnectionPool
implements ConnectionPool {
    private HikariDataSource dataSource;
    private int maxConnections;

    public HikariConnectionPool(String driver, String url, String username, String password, int maxConnections, boolean jdbc4, String testQuery, boolean readOnly) {
        this.maxConnections = maxConnections;
        this.dataSource = new HikariDataSource();
        this.dataSource.setDriverClassName(driver);
        this.dataSource.setJdbcUrl(url);
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        this.dataSource.setConnectionTimeout(0L);
        this.dataSource.setAutoCommit(false);
        this.dataSource.setMaximumPoolSize(maxConnections);
        this.dataSource.setMinimumIdle(0);
        this.dataSource.setReadOnly(readOnly);
        if (!jdbc4) {
            this.dataSource.setConnectionTestQuery(testQuery);
        }
    }

    @Override
    public PooledConnection getConnection() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        return new PooledConnection(connection, connection.unwrap(Connection.class));
    }

    @Override
    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

