/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.channel.Statistics;
import com.mirth.connect.donkey.server.controllers.ChannelController;
import com.mirth.connect.donkey.server.data.DonkeyDaoException;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import com.mirth.connect.donkey.server.data.jdbc.CachedPreparedStatementSource;
import com.mirth.connect.donkey.server.data.jdbc.ConnectionPool;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDao;
import com.mirth.connect.donkey.server.data.jdbc.MysqlDaoFactory;
import com.mirth.connect.donkey.server.data.jdbc.OracleDaoFactory;
import com.mirth.connect.donkey.server.data.jdbc.PooledConnection;
import com.mirth.connect.donkey.server.data.jdbc.PostgresqlDaoFactory;
import com.mirth.connect.donkey.server.data.jdbc.PreparedStatementSource;
import com.mirth.connect.donkey.server.data.jdbc.QuerySource;
import com.mirth.connect.donkey.server.data.jdbc.SqlServerDaoFactory;
import com.mirth.connect.donkey.util.SerializerProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JdbcDaoFactory
implements DonkeyDaoFactory {
    private Donkey donkey;
    private ChannelController channelController;
    private String statsServerId;
    private ConnectionPool connectionPool;
    private QuerySource querySource;
    private SerializerProvider serializerProvider;
    private StatisticsUpdater statisticsUpdater;
    private boolean encryptMessageContent = false;
    private boolean encryptAttachments = false;
    private boolean encryptCustomMetaData = false;
    private boolean decryptData = true;
    private Map<Connection, PreparedStatementSource> statementSources = new ConcurrentHashMap<Connection, PreparedStatementSource>();
    private Logger logger = LogManager.getLogger(this.getClass());

    public static JdbcDaoFactory getInstance() {
        return JdbcDaoFactory.getInstance(null);
    }

    public static JdbcDaoFactory getInstance(String database) {
        if (database == null) {
            return new JdbcDaoFactory();
        }
        if (database.equals("postgres")) {
            return new PostgresqlDaoFactory();
        }
        if (database.equals("oracle")) {
            return new OracleDaoFactory();
        }
        if (database.equals("mysql")) {
            return new MysqlDaoFactory();
        }
        if (database.equals("sqlserver")) {
            return new SqlServerDaoFactory();
        }
        return new JdbcDaoFactory();
    }

    protected JdbcDaoFactory() {
        this.donkey = Donkey.getInstance();
        this.channelController = ChannelController.getInstance();
    }

    public String getStatsServerId() {
        return this.statsServerId;
    }

    public void setStatsServerId(String serverId) {
        this.statsServerId = serverId;
    }

    @Override
    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public QuerySource getQuerySource() {
        return this.querySource;
    }

    public void setQuerySource(QuerySource querySource) {
        this.querySource = querySource;
    }

    public void setSerializerProvider(SerializerProvider serializerProvider) {
        this.serializerProvider = serializerProvider;
    }

    public Map<Connection, PreparedStatementSource> getStatementSources() {
        return this.statementSources;
    }

    @Override
    public void setEncryptData(boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData) {
        this.encryptMessageContent = encryptMessageContent;
        this.encryptAttachments = encryptAttachments;
        this.encryptCustomMetaData = encryptCustomMetaData;
    }

    @Override
    public void setDecryptData(boolean decryptData) {
        this.decryptData = decryptData;
    }

    @Override
    public void setStatisticsUpdater(StatisticsUpdater statisticsUpdater) {
        this.statisticsUpdater = statisticsUpdater;
    }

    @Override
    public JdbcDao getDao() {
        return this.getDao(this.serializerProvider);
    }

    @Override
    public JdbcDao getDao(SerializerProvider serializerProvider) {
        PooledConnection pooledConnection;
        try {
            pooledConnection = this.connectionPool.getConnection();
        }
        catch (SQLException e) {
            throw new DonkeyDaoException(e);
        }
        PreparedStatementSource statementSource = null;
        Connection connection = pooledConnection.getConnection();
        Connection internalConnection = pooledConnection.getInternalConnection();
        statementSource = this.statementSources.get(internalConnection);
        if (statementSource == null) {
            statementSource = new CachedPreparedStatementSource(internalConnection, this.querySource);
            this.statementSources.put(internalConnection, statementSource);
            Integer maxConnections = this.connectionPool.getMaxConnections();
            if (maxConnections == null || this.statementSources.size() > maxConnections) {
                this.logger.debug("cleaning up prepared statement cache");
                try {
                    for (Connection currentConnection : this.statementSources.keySet()) {
                        if (!currentConnection.isClosed()) continue;
                        this.statementSources.remove(currentConnection);
                    }
                }
                catch (SQLException e) {
                    throw new DonkeyDaoException(e);
                }
            }
        }
        return this.getDao(this.donkey, connection, this.querySource, statementSource, serializerProvider, this.encryptMessageContent, this.encryptAttachments, this.encryptCustomMetaData, this.decryptData, this.statisticsUpdater, this.channelController.getStatistics(), this.channelController.getTotalStatistics(), this.statsServerId);
    }

    protected JdbcDao getDao(Donkey donkey, Connection connection, QuerySource querySource, PreparedStatementSource statementSource, SerializerProvider serializerProvider, boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData, boolean decryptData, StatisticsUpdater statisticsUpdater, Statistics currentStats, Statistics totalStats, String statsServerId) {
        return new JdbcDao(donkey, connection, querySource, statementSource, serializerProvider, encryptMessageContent, encryptAttachments, encryptCustomMetaData, decryptData, statisticsUpdater, currentStats, totalStats, statsServerId);
    }
}

