/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.jdbc;

import com.mirth.connect.donkey.server.data.DonkeyDaoException;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDao;
import com.mirth.connect.donkey.server.data.jdbc.JdbcDaoFactory;
import com.mirth.connect.donkey.util.SerializerProvider;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;

public class SqlServerDaoFactory
extends JdbcDaoFactory {
    private Integer deadlockPriority = 8;

    public Integer getDeadlockPriority() {
        return this.deadlockPriority;
    }

    public void setDeadlockPriority(Integer deadlockPriority) {
        this.deadlockPriority = deadlockPriority;
    }

    @Override
    public JdbcDao getDao(SerializerProvider serializerProvider) {
        JdbcDao dao = super.getDao(serializerProvider);
        if (this.deadlockPriority != null) {
            Statement statement = null;
            try {
                statement = dao.getConnection().createStatement();
                statement.executeUpdate("SET DEADLOCK_PRIORITY " + this.deadlockPriority);
            }
            catch (SQLException e) {
                throw new DonkeyDaoException(e);
            }
            finally {
                DbUtils.closeQuietly((Statement)statement);
            }
        }
        return dao;
    }
}

