/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.data.timed;

import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import com.mirth.connect.donkey.server.data.StatisticsUpdater;
import com.mirth.connect.donkey.server.data.jdbc.ConnectionPool;
import com.mirth.connect.donkey.server.data.timed.TimedDao;
import com.mirth.connect.donkey.util.ActionTimer;
import com.mirth.connect.donkey.util.SerializerProvider;

public class TimedDaoFactory
implements DonkeyDaoFactory {
    private DonkeyDaoFactory delegateFactory;
    private ActionTimer timer;
    private boolean encryptMessageContent = false;
    private boolean encryptAttachments = false;
    private boolean encryptCustomMetaData = false;
    private boolean decryptData = true;
    private StatisticsUpdater statisticsUpdater;

    public TimedDaoFactory(DonkeyDaoFactory delegateFactory, ActionTimer timer) {
        this.delegateFactory = delegateFactory;
        this.timer = timer;
    }

    public DonkeyDaoFactory getDelegateFactory() {
        return this.delegateFactory;
    }

    public void setDelegateFactory(DonkeyDaoFactory delegateFactory) {
        this.delegateFactory = delegateFactory;
    }

    public ActionTimer getTimer() {
        return this.timer;
    }

    public void setTimer(ActionTimer timer) {
        this.timer = timer;
    }

    @Override
    public void setEncryptData(boolean encryptMessageContent, boolean encryptAttachments, boolean encryptCustomMetaData) {
        this.encryptMessageContent = encryptMessageContent;
        this.encryptAttachments = encryptAttachments;
        this.encryptCustomMetaData = encryptCustomMetaData;
    }

    @Override
    public void setDecryptData(boolean decryptData) {
        this.decryptData = decryptData;
    }

    @Override
    public void setStatisticsUpdater(StatisticsUpdater statisticsUpdater) {
        this.statisticsUpdater = statisticsUpdater;
    }

    @Override
    public DonkeyDao getDao() {
        TimedDao dao = new TimedDao(this.delegateFactory.getDao(), this.timer);
        dao.setEncryptData(this.encryptMessageContent, this.encryptAttachments, this.encryptCustomMetaData);
        dao.setDecryptData(this.decryptData);
        dao.setStatisticsUpdater(this.statisticsUpdater);
        return dao;
    }

    @Override
    public DonkeyDao getDao(SerializerProvider serializerProvider) {
        TimedDao dao = new TimedDao(this.delegateFactory.getDao(serializerProvider), this.timer);
        dao.setEncryptData(this.encryptMessageContent, this.encryptAttachments, this.encryptCustomMetaData);
        dao.setDecryptData(this.decryptData);
        dao.setStatisticsUpdater(this.statisticsUpdater);
        return dao;
    }

    @Override
    public ConnectionPool getConnectionPool() {
        return this.delegateFactory.getConnectionPool();
    }
}

