/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.message.batch;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;

public abstract class BatchAdaptor {
    private BatchAdaptorFactory factory;
    protected SourceConnector sourceConnector;
    protected BatchRawMessage batchRawMessage;
    private int batchSequenceId;
    private boolean lookAhead = true;
    private String nextMessage = null;

    public BatchAdaptor(BatchAdaptorFactory factory, SourceConnector sourceConnector, BatchRawMessage batchRawMessage) {
        this.factory = factory;
        this.sourceConnector = sourceConnector;
        this.batchRawMessage = batchRawMessage;
    }

    public BatchAdaptorFactory getFactory() {
        return this.factory;
    }

    public String getMessage() throws BatchMessageException {
        try {
            if (this.lookAhead) {
                String message = null;
                ++this.batchSequenceId;
                message = this.batchSequenceId == 1 ? this.getNextMessage(this.batchSequenceId) : this.nextMessage;
                if (message != null) {
                    this.nextMessage = this.getNextMessage(this.batchSequenceId + 1);
                }
                return message;
            }
            return this.getNextMessage(++this.batchSequenceId);
        }
        catch (Exception e) {
            if (e instanceof BatchMessageException) {
                throw (BatchMessageException)e;
            }
            throw new BatchMessageException("Failed to retrieve batch message at sequence number " + this.batchSequenceId, e);
        }
    }

    public boolean isLookAhead() {
        return this.lookAhead;
    }

    public boolean isBatchComplete() {
        return this.lookAhead && this.nextMessage == null;
    }

    public int getBatchSequenceId() {
        return this.batchSequenceId;
    }

    protected abstract String getNextMessage(int var1) throws Exception;

    public abstract void cleanup() throws BatchMessageException;
}

