/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.queue;

import com.mirth.connect.donkey.model.event.MessageEventType;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.Donkey;
import com.mirth.connect.donkey.server.event.EventDispatcher;
import com.mirth.connect.donkey.server.event.MessageEvent;
import com.mirth.connect.donkey.server.queue.ConnectorMessageQueueDataSource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ConnectorMessageQueue {
    protected Map<Long, ConnectorMessage> buffer = new LinkedHashMap<Long, ConnectorMessage>();
    protected Integer size;
    protected ConnectorMessageQueueDataSource dataSource;
    protected final AtomicBoolean timeoutLock = new AtomicBoolean(false);
    protected EventDispatcher eventDispatcher = Donkey.getInstance().getEventDispatcher();
    protected String channelId;
    protected Integer metaDataId;
    private int bufferCapacity = 1000;
    private boolean reachedCapacity = false;
    private boolean invalidated = false;

    protected abstract ConnectorMessage pollFirstValue();

    protected void reset() {
    }

    public int getBufferSize() {
        return this.buffer.size();
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public synchronized void setBufferCapacity(int bufferCapacity) {
        if (bufferCapacity > 0) {
            if (bufferCapacity < this.bufferCapacity) {
                this.buffer.clear();
            }
            this.bufferCapacity = bufferCapacity;
        }
    }

    public ConnectorMessageQueueDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ConnectorMessageQueueDataSource dataSource) {
        this.channelId = dataSource.getChannelId();
        this.metaDataId = dataSource.getMetaDataId();
        this.dataSource = dataSource;
        this.invalidate(false, true);
    }

    public synchronized void updateSize() {
        this.size = this.dataSource.getSize();
    }

    public synchronized void updateSizeIfEmpty() {
        if (this.size == null || this.size == 0) {
            this.updateSize();
        }
    }

    public synchronized void invalidate(boolean updateSize, boolean reset) {
        this.buffer.clear();
        if (reset) {
            this.reset();
        }
        this.size = null;
        this.invalidated = true;
        if (updateSize) {
            this.eventDispatcher.dispatchEvent(new MessageEvent(this.channelId, this.metaDataId, MessageEventType.QUEUED, Long.valueOf(this.size()), true));
        }
    }

    public synchronized boolean contains(ConnectorMessage connectorMessage) {
        return this.buffer.containsKey(connectorMessage.getMessageId());
    }

    public boolean isEmpty() {
        if (this.size == null) {
            this.updateSize();
        }
        return this.size == 0;
    }

    public int size() {
        if (this.size == null) {
            if (this.dataSource == null) {
                return 0;
            }
            this.updateSize();
        }
        return this.size;
    }

    protected void incrementActualSize() {
        Integer n = this.size;
        this.size = this.size + 1;
    }

    protected void decrementActualSize() {
        Integer n = this.size;
        this.size = this.size - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(ConnectorMessage connectorMessage) {
        if (this.invalidated) {
            if (this.size != null) {
                this.incrementActualSize();
            }
            this.fillBuffer();
        } else {
            if (this.size == null) {
                this.updateSize();
            }
            if (!this.reachedCapacity) {
                if (this.size < this.bufferCapacity && !this.dataSource.isQueueRotated()) {
                    if (this.canAddNewMessageToBuffer(connectorMessage)) {
                        this.buffer.put(connectorMessage.getMessageId(), connectorMessage);
                        if (this.timeoutLock.get()) {
                            AtomicBoolean atomicBoolean = this.timeoutLock;
                            synchronized (atomicBoolean) {
                                this.timeoutLock.notifyAll();
                                this.timeoutLock.set(false);
                            }
                        }
                    }
                } else {
                    this.reachedCapacity = true;
                }
            }
            this.incrementActualSize();
        }
        this.eventDispatcher.dispatchEvent(new MessageEvent(this.channelId, this.metaDataId, MessageEventType.QUEUED, Long.valueOf(this.size()), false));
    }

    protected boolean canAddNewMessageToBuffer(ConnectorMessage connectorMessage) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fillBuffer() {
        if (this.size == null) {
            this.updateSize();
        }
        this.invalidated = false;
        this.buffer = this.dataSource.getItems(0, Math.min(this.bufferCapacity, this.size));
        if (this.buffer.size() == this.size.intValue()) {
            this.reachedCapacity = false;
        }
        if (this.buffer.size() > 0 && this.timeoutLock.get()) {
            AtomicBoolean atomicBoolean = this.timeoutLock;
            synchronized (atomicBoolean) {
                this.timeoutLock.notifyAll();
                this.timeoutLock.set(false);
            }
        }
    }
}

