/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.queue;

import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.server.data.DonkeyDao;
import com.mirth.connect.donkey.server.data.DonkeyDaoFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectorMessageQueueDataSource {
    private DonkeyDaoFactory daoFactory;
    private String channelId;
    private String serverId;
    private int metaDataId;
    private Status status;
    private boolean rotate;
    private Long maxMessageId = null;
    private Long minMessageId = null;
    private Long rotatedMessageId = null;
    private ConcurrentHashMap<Long, Boolean> rotateThreadMap;

    public ConnectorMessageQueueDataSource(String channelId, String serverId, int metaDataId, Status status, boolean rotate, DonkeyDaoFactory daoFactory) {
        this.channelId = channelId;
        this.serverId = serverId;
        this.metaDataId = metaDataId;
        this.status = status;
        this.rotate = rotate;
        this.daoFactory = daoFactory;
        if (rotate) {
            this.rotateThreadMap = new ConcurrentHashMap();
        }
    }

    public DonkeyDaoFactory getDaoFactory() {
        return this.daoFactory;
    }

    public void setDaoFactory(DonkeyDaoFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getMetaDataId() {
        return this.metaDataId;
    }

    public void setMetaDataId(int metaDataId) {
        this.metaDataId = metaDataId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ConcurrentHashMap<Long, Boolean> getRotateThreadMap() {
        return this.rotateThreadMap;
    }

    public void setLastItem(ConnectorMessage connectorMessage) {
        if (this.rotatedMessageId == null || connectorMessage.getMessageId() >= this.rotatedMessageId) {
            this.rotatedMessageId = connectorMessage.getMessageId() + 1L;
        }
        if (this.isQueueRotated()) {
            this.rotateQueue();
        }
    }

    public void rotateQueue() {
        this.minMessageId = this.rotatedMessageId;
        if (this.maxMessageId == null) {
            try (DonkeyDao dao = this.getDaoFactory().getDao();){
                this.maxMessageId = dao.getConnectorMessageMaxMessageId(this.channelId, this.serverId, this.metaDataId, this.status);
            }
        }
    }

    public boolean isQueueRotated() {
        return this.rotate && this.minMessageId != null && this.minMessageId != 0L;
    }

    public int getSize() {
        try (DonkeyDao dao = this.getDaoFactory().getDao();){
            if (this.rotate) {
                this.minMessageId = 0L;
                this.rotatedMessageId = null;
            } else {
                this.minMessageId = null;
            }
            this.maxMessageId = null;
            int n = dao.getConnectorMessageCount(this.channelId, this.serverId, this.metaDataId, this.status);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, ConnectorMessage> getItems(int offset, int limit) {
        try (DonkeyDao dao = this.daoFactory.getDao();){
            List<ConnectorMessage> connectorMessages = dao.getConnectorMessages(this.channelId, this.serverId, this.metaDataId, this.status, offset, limit, this.minMessageId, this.maxMessageId);
            if (this.rotate && connectorMessages.size() == 0) {
                this.minMessageId = 0L;
                this.maxMessageId = null;
                this.rotatedMessageId = null;
                connectorMessages = dao.getConnectorMessages(this.channelId, this.serverId, this.metaDataId, this.status, offset, limit, this.minMessageId, this.maxMessageId);
                if (connectorMessages.size() > 0) {
                    for (Long threadId : ((ConcurrentHashMap.CollectionView)((Object)this.rotateThreadMap.keySet())).toArray(new Long[this.rotateThreadMap.size()])) {
                        this.rotateThreadMap.put(threadId, true);
                    }
                }
            }
            LinkedHashMap<Long, ConnectorMessage> map = new LinkedHashMap<Long, ConnectorMessage>();
            for (ConnectorMessage connectorMessage : connectorMessages) {
                map.put(connectorMessage.getMessageId(), connectorMessage);
            }
            LinkedHashMap<Long, ConnectorMessage> linkedHashMap = map;
            return linkedHashMap;
        }
    }
}

