/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.server.queue;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.event.MessageEventType;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.server.event.MessageEvent;
import com.mirth.connect.donkey.server.queue.ConnectorMessageQueue;
import com.mirth.connect.donkey.util.MessageMaps;
import com.mirth.connect.donkey.util.Serializer;
import com.mirth.connect.donkey.util.xstream.SerializerException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;

public class DestinationQueue
extends ConnectorMessageQueue {
    private String groupBy;
    private boolean regenerateTemplate;
    private Serializer serializer;
    private MessageMaps messageMaps;
    private Set<Long> checkedOut = new HashSet<Long>();
    private Set<Long> deleted = new HashSet<Long>();
    private boolean rotate = false;
    private int queueBuckets = 1;
    private List<Long> queueThreadIds;
    private HashFunction hashFunction;
    private Map<String, Integer> initialThreadAssignmentMap;
    private ReentrantReadWriteLock statusUpdateLock = new ReentrantReadWriteLock(true);

    public DestinationQueue(String groupBy, int threadCount, boolean regenerateTemplate, Serializer serializer, MessageMaps messageMaps) {
        this.groupBy = StringUtils.defaultString((String)groupBy);
        this.regenerateTemplate = regenerateTemplate;
        this.serializer = serializer;
        this.messageMaps = messageMaps;
        if (StringUtils.isNotBlank((CharSequence)groupBy)) {
            this.queueBuckets = threadCount;
            if (this.queueBuckets > 1) {
                this.queueThreadIds = new ArrayList<Long>(this.queueBuckets);
                this.hashFunction = Hashing.murmur3_32((int)((int)System.currentTimeMillis()));
                this.initialThreadAssignmentMap = new ConcurrentHashMap<String, Integer>(this.queueBuckets);
            }
        }
    }

    @Override
    protected ConnectorMessage pollFirstValue() {
        Iterator iterator = this.buffer.entrySet().iterator();
        while (iterator.hasNext()) {
            ConnectorMessage connectorMessage = (ConnectorMessage)iterator.next().getValue();
            if (this.queueBuckets > 1) {
                Integer bucket = this.getBucket(connectorMessage);
                if (bucket >= this.queueThreadIds.size() || !this.queueThreadIds.get(bucket).equals(Thread.currentThread().getId())) continue;
                iterator.remove();
                return connectorMessage;
            }
            iterator.remove();
            return connectorMessage;
        }
        return null;
    }

    public Lock getStatusUpdateLock() {
        return this.statusUpdateLock.readLock();
    }

    public Lock getInvalidationLock() {
        return this.statusUpdateLock.writeLock();
    }

    @Override
    protected void reset() {
        this.checkedOut.clear();
        this.deleted.clear();
        if (this.queueBuckets > 1) {
            this.queueThreadIds.clear();
        }
        if (this.rotate) {
            this.dataSource.getRotateThreadMap().clear();
        }
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    public synchronized void registerThreadId() {
        Long threadId = Thread.currentThread().getId();
        if (this.queueBuckets > 1) {
            this.queueThreadIds.add(threadId);
        }
        if (this.rotate) {
            this.dataSource.getRotateThreadMap().put(threadId, false);
        }
    }

    public boolean hasBeenRotated() {
        if (this.rotate) {
            Long threadId = Thread.currentThread().getId();
            Boolean rotated = this.dataSource.getRotateThreadMap().get(threadId);
            if (rotated == null || rotated.booleanValue()) {
                if (rotated == null) {
                    rotated = false;
                }
                this.dataSource.getRotateThreadMap().put(threadId, false);
            }
            return rotated;
        }
        return false;
    }

    public synchronized ConnectorMessage acquire() {
        ConnectorMessage connectorMessage = null;
        if (this.size() - this.checkedOut.size() > 0) {
            boolean bufferFilled = false;
            do {
                if (this.size == null) {
                    this.updateSize();
                }
                if (this.size <= 0) continue;
                connectorMessage = this.pollFirstValue();
                if (connectorMessage == null && this.buffer.size() == 0) {
                    if (bufferFilled) {
                        return null;
                    }
                    this.fillBuffer();
                    bufferFilled = true;
                    connectorMessage = this.pollFirstValue();
                }
                if (connectorMessage == null || !this.rotate) continue;
                this.dataSource.setLastItem(connectorMessage);
            } while (connectorMessage != null && this.checkedOut.contains(connectorMessage.getMessageId()));
        }
        if (connectorMessage != null) {
            this.checkedOut.add(connectorMessage.getMessageId());
        }
        return connectorMessage;
    }

    public synchronized void release(ConnectorMessage connectorMessage, boolean finished) {
        if (connectorMessage != null) {
            if (this.size != null) {
                Long messageId = connectorMessage.getMessageId();
                if (finished) {
                    this.decrementActualSize();
                    if (this.buffer.containsKey(messageId)) {
                        this.buffer.remove(messageId);
                    }
                } else {
                    if (this.buffer.containsKey(messageId)) {
                        this.buffer.put(messageId, connectorMessage);
                    }
                    this.dataSource.rotateQueue();
                }
            }
            this.checkedOut.remove(connectorMessage.getMessageId());
            if (finished) {
                this.eventDispatcher.dispatchEvent(new MessageEvent(this.channelId, this.metaDataId, MessageEventType.QUEUED, Long.valueOf(this.size()), true));
            }
        }
    }

    public synchronized boolean isCheckedOut(Long messageId) {
        boolean isCheckedOut = this.checkedOut.contains(messageId);
        if (!isCheckedOut && this.deleted.contains(messageId)) {
            this.deleted.remove(messageId);
            this.buffer.remove(messageId);
            this.updateSize();
        }
        return isCheckedOut;
    }

    public synchronized void markAsDeleted(Long messageId) {
        this.deleted.add(messageId);
    }

    public synchronized boolean releaseIfDeleted(ConnectorMessage connectorMessage) {
        if (this.deleted.contains(connectorMessage.getMessageId())) {
            this.release(connectorMessage, true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getBucket(ConnectorMessage connectorMessage) {
        Integer bucket = connectorMessage.getQueueBucket();
        if (bucket == null || this.regenerateTemplate) {
            String groupByValue;
            String groupByVariable = this.groupBy;
            if (!this.regenerateTemplate) {
                try {
                    ConnectorProperties sentProperties = connectorMessage.getSentProperties();
                    if (sentProperties == null) {
                        sentProperties = this.serializer.deserialize(connectorMessage.getSent().getContent(), ConnectorProperties.class);
                        connectorMessage.setSentProperties(sentProperties);
                    }
                    groupByVariable = StringUtils.defaultString((String)((DestinationConnectorPropertiesInterface)((Object)sentProperties)).getDestinationConnectorProperties().getThreadAssignmentVariable());
                }
                catch (SerializerException sentProperties) {
                    // empty catch block
                }
            }
            if ((bucket = this.initialThreadAssignmentMap.get(groupByValue = String.valueOf(this.messageMaps.get(groupByVariable, connectorMessage)))) == null) {
                if (this.initialThreadAssignmentMap.size() < this.queueBuckets) {
                    Map<String, Integer> map = this.initialThreadAssignmentMap;
                    synchronized (map) {
                        int size = this.initialThreadAssignmentMap.size();
                        if (size < this.queueBuckets) {
                            bucket = size;
                            this.initialThreadAssignmentMap.put(groupByValue, bucket);
                        }
                    }
                }
                if (bucket == null) {
                    bucket = Math.abs(this.hashFunction.hashUnencodedChars((CharSequence)groupByValue).asInt() % this.queueBuckets);
                }
            }
            connectorMessage.setQueueBucket(bucket);
        }
        return bucket;
    }
}

