/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.donkey.util;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.dom2_builder.DOM2XmlPullBuilder;

public class DonkeyElement
implements Element {
    private Element element;

    public DonkeyElement(Element element) {
        this.element = element;
    }

    public DonkeyElement(String xml) throws DonkeyElementException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            this.element = this.fromXml(xml, dbf.newDocumentBuilder().newDocument());
        }
        catch (ParserConfigurationException e) {
            throw new DonkeyElementException(e);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public DonkeyElement getChildElement(String name) {
        NodeList children = this.element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            if (!children.item(i).getNodeName().equals(name) || children.item(i).getNodeType() != 1) continue;
            return new DonkeyElement((Element)children.item(i));
        }
        return null;
    }

    public List<DonkeyElement> getChildElements() {
        NodeList childNodes = this.element.getChildNodes();
        int childCount = childNodes.getLength();
        ArrayList<DonkeyElement> childElements = new ArrayList<DonkeyElement>();
        for (int i = 0; i < childCount; ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            childElements.add(new DonkeyElement((Element)node));
        }
        return childElements;
    }

    public DonkeyElement addChildElement(String name) {
        Element child = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(child);
        return new DonkeyElement(child);
    }

    public DonkeyElement addChildElement(String name, String content) {
        Element child = this.element.getOwnerDocument().createElement(name);
        this.element.appendChild(child);
        child.setTextContent(content);
        return new DonkeyElement(child);
    }

    public DonkeyElement addChildElementIfNotExists(String name) {
        DonkeyElement child = this.getChildElement(name);
        if (child == null) {
            child = this.addChildElement(name);
        }
        return child;
    }

    public DonkeyElement addChildElementIfNotExists(String name, String content) {
        DonkeyElement child = this.getChildElement(name);
        if (child == null) {
            child = this.addChildElement(name, content);
        }
        return child;
    }

    public DonkeyElement addChildElementFromXml(String xml) throws DonkeyElementException {
        Element child = this.fromXml(xml, this.element.getOwnerDocument());
        this.element.appendChild(child);
        return new DonkeyElement(child);
    }

    public DonkeyElement removeChild(String name) {
        NodeList children = this.element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            if (!children.item(i).getNodeName().equals(name) || children.item(i).getNodeType() != 1) continue;
            return new DonkeyElement((Element)this.element.removeChild(children.item(i)));
        }
        return null;
    }

    public void removeChildren() {
        NodeList children = this.element.getChildNodes();
        int childCount = children.getLength();
        for (int i = childCount - 1; i >= 0; --i) {
            this.element.removeChild(children.item(i));
        }
    }

    public boolean removeChildren(String name) {
        NodeList children = this.element.getChildNodes();
        int childCount = children.getLength();
        boolean removed = false;
        for (int i = childCount - 1; i >= 0; --i) {
            if (!children.item(i).getNodeName().equals(name)) continue;
            this.element.removeChild(children.item(i));
            removed = true;
        }
        return removed;
    }

    public void setNodeName(String name) {
        this.element.getOwnerDocument().renameNode(this.element, this.element.getNamespaceURI(), name);
    }

    @Override
    public String getNodeName() {
        return this.element.getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.element.getNodeValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.element.setNodeValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        return this.element.getNodeType();
    }

    @Override
    public Node getParentNode() {
        return this.element.getParentNode();
    }

    @Override
    public NodeList getChildNodes() {
        return this.element.getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        return this.element.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        return this.element.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return this.element.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        return this.element.getNextSibling();
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.element.getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return this.element.getOwnerDocument();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.element.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return this.element.replaceChild(newChild, oldChild);
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return this.element.removeChild(oldChild);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return this.element.appendChild(newChild);
    }

    @Override
    public boolean hasChildNodes() {
        return this.element.hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean deep) {
        return this.element.cloneNode(deep);
    }

    @Override
    public void normalize() {
        this.element.normalize();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.element.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return this.element.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.element.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.element.setPrefix(prefix);
    }

    @Override
    public String getLocalName() {
        return this.element.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.element.hasAttributes();
    }

    @Override
    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return this.element.compareDocumentPosition(other);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.element.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.element.setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(Node other) {
        return this.element.isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.element.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.element.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.element.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return this.element.isEqualNode(arg);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.element.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.element.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.element.getUserData(key);
    }

    @Override
    public String getTagName() {
        return this.element.getTagName();
    }

    @Override
    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        this.element.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        this.element.removeAttribute(name);
    }

    @Override
    public Attr getAttributeNode(String name) {
        return this.element.getAttributeNode(name);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.element.setAttributeNode(newAttr);
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return this.element.removeAttributeNode(oldAttr);
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        return this.element.getElementsByTagName(name);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.element.getAttributeNS(namespaceURI, localName);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.element.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.element.removeAttributeNS(namespaceURI, localName);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return this.element.getAttributeNodeNS(namespaceURI, localName);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.element.setAttributeNodeNS(newAttr);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return this.element.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.element.hasAttribute(name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.element.hasAttributeNS(namespaceURI, localName);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return this.element.getSchemaTypeInfo();
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.element.setIdAttribute(name, isId);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.element.setIdAttributeNS(namespaceURI, localName, isId);
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.element.setIdAttributeNode(idAttr, isId);
    }

    public String toXml() throws DonkeyElementException {
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(this.element), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new DonkeyElementException(e);
        }
        return ((Object)writer).toString();
    }

    private Element fromXml(String xml, Document document) throws DonkeyElementException {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)"org.xmlpull.mxp1.MXParserFactory", null);
            XmlPullParser pp = factory.newPullParser();
            pp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            pp.setInput((Reader)new StringReader(xml));
            pp.next();
            return new DOM2XmlPullBuilder().parse(pp, document);
        }
        catch (Exception e) {
            throw new DonkeyElementException(e);
        }
    }

    public String toString() {
        try {
            return this.toXml();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static class DonkeyElementException
    extends Exception {
        public DonkeyElementException(Throwable cause) {
            super(cause);
        }
    }
}

