/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.commons.encryption;

import com.mirth.commons.encryption.EncryptionException;
import com.mirth.commons.encryption.Encryptor;
import com.mirth.commons.encryption.Output;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;

public class PBEEncryptor
extends Encryptor {
    public static final int DEFAULT_SALT_SIZE = 8;
    public static final int DEFAULT_ITERATIONS = 5000;
    private SecretKey key;
    private String algorithm;
    private String password;
    private SecureRandom saltGenerator;
    private int saltSizeBytes = 8;
    private int iterations = 5000;
    private boolean includeSalt = true;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SecureRandom getSaltGenerator() {
        return this.saltGenerator;
    }

    public void setSaltGenerator(SecureRandom saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public int getSaltSizeBytes() {
        return this.saltSizeBytes;
    }

    public void setSaltSizeBytes(int saltSizeBytes) {
        this.saltSizeBytes = saltSizeBytes;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public boolean isIncludeSalt() {
        return this.includeSalt;
    }

    public void setIncludeSalt(boolean includeSalt) {
        this.includeSalt = includeSalt;
    }

    @Override
    public synchronized void initialize() throws EncryptionException {
        if (!this.isInitialized()) {
            try {
                PBEKeySpec pbeKeySpec = new PBEKeySpec(this.password.toCharArray());
                SecretKeyFactory factory = SecretKeyFactory.getInstance(this.getAlgorithm(), this.getProvider());
                this.key = factory.generateSecret(pbeKeySpec);
                this.saltGenerator = SecureRandom.getInstance("SHA1PRNG");
            }
            catch (Exception e) {
                throw new EncryptionException(e);
            }
            this.setInitialized(true);
        }
    }

    @Override
    public String encrypt(String message) throws EncryptionException {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            byte[] encrypted = this.doEncrypt(message.getBytes());
            if (this.getFormat() == Output.HEXADECIMAL) {
                return Hex.encodeHexString((byte[])encrypted);
            }
            return new String(Base64.encodeBase64Chunked((byte[])encrypted));
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public Encryptor.EncryptedData encrypt(byte[] data) throws EncryptionException {
        throw new UnsupportedOperationException();
    }

    private byte[] doEncrypt(byte[] message) throws Exception {
        byte[] salt = this.saltGenerator.generateSeed(this.saltSizeBytes);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, this.iterations);
        Cipher cipher = Cipher.getInstance(this.getAlgorithm(), this.getProvider());
        cipher.init(1, (Key)this.key, parameterSpec);
        byte[] encrypted = cipher.doFinal(message);
        if (this.includeSalt) {
            return ArrayUtils.addAll((byte[])salt, (byte[])encrypted);
        }
        return encrypted;
    }

    @Override
    public String decrypt(String message) throws EncryptionException {
        if (message == null) {
            return null;
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            if (this.getFormat() == Output.HEXADECIMAL) {
                return new String(this.decrypt(Hex.decodeHex((char[])message.toCharArray())));
            }
            return new String(this.decrypt(Base64.decodeBase64((String)message)));
        }
        catch (Exception e) {
            throw new EncryptionException(e);
        }
    }

    @Override
    public byte[] decrypt(String header, byte[] data) throws EncryptionException {
        throw new UnsupportedOperationException();
    }

    private byte[] decrypt(byte[] message) throws Exception {
        byte[] salt = new byte[this.saltSizeBytes];
        System.arraycopy(message, 0, salt, 0, this.saltSizeBytes);
        byte[] kernel = new byte[message.length - this.saltSizeBytes];
        System.arraycopy(message, this.saltSizeBytes, kernel, 0, kernel.length);
        PBEParameterSpec parameterSpec = new PBEParameterSpec(salt, this.iterations);
        Cipher cipher = Cipher.getInstance(this.getAlgorithm(), this.getProvider());
        cipher.init(2, (Key)this.key, parameterSpec);
        return cipher.doFinal(kernel);
    }
}

