/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.plugins.datatypes.delimited;

import com.mirth.connect.donkey.model.message.BatchRawMessage;
import com.mirth.connect.donkey.server.channel.SourceConnector;
import com.mirth.connect.donkey.server.message.batch.BatchAdaptorFactory;
import com.mirth.connect.donkey.server.message.batch.BatchMessageException;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReader;
import com.mirth.connect.donkey.server.message.batch.BatchMessageReceiver;
import com.mirth.connect.plugins.datatypes.delimited.DelimitedBatchProperties;
import com.mirth.connect.plugins.datatypes.delimited.DelimitedReader;
import com.mirth.connect.plugins.datatypes.delimited.DelimitedSerializationProperties;
import com.mirth.connect.server.controllers.ContextFactoryController;
import com.mirth.connect.server.controllers.ControllerFactory;
import com.mirth.connect.server.controllers.ScriptController;
import com.mirth.connect.server.message.DebuggableBatchAdaptor;
import com.mirth.connect.server.message.DebuggableBatchAdaptorFactory;
import com.mirth.connect.server.userutil.SourceMap;
import com.mirth.connect.server.util.javascript.JavaScriptExecutorException;
import com.mirth.connect.server.util.javascript.JavaScriptTask;
import com.mirth.connect.server.util.javascript.JavaScriptUtil;
import com.mirth.connect.util.StringUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelimitedBatchAdaptor
extends DebuggableBatchAdaptor {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private ContextFactoryController contextFactoryController = ControllerFactory.getFactory().createContextFactoryController();
    private DelimitedSerializationProperties serializationProperties;
    private DelimitedReader delimitedReader = null;
    private BufferedReader bufferedReader;
    private boolean skipHeader;
    private Integer groupingColumnIndex;
    private String batchMessageDelimiter = null;

    public DelimitedBatchAdaptor(DebuggableBatchAdaptorFactory factory, SourceConnector sourceConnector, BatchRawMessage batchRawMessage) {
        super((BatchAdaptorFactory)factory, sourceConnector, batchRawMessage);
    }

    public DelimitedSerializationProperties getSerializationProperties() {
        return this.serializationProperties;
    }

    public void setSerializationProperties(DelimitedSerializationProperties serializationProperties) {
        this.serializationProperties = serializationProperties;
    }

    public DelimitedReader getDelimitedReader() {
        return this.delimitedReader;
    }

    public void setDelimitedReader(DelimitedReader delimitedReader) {
        this.delimitedReader = delimitedReader;
    }

    public void cleanup() throws BatchMessageException {
    }

    protected String getNextMessage(int batchSequenceId) throws Exception {
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReader) {
            if (batchSequenceId == 1) {
                BatchMessageReader batchMessageReader = (BatchMessageReader)this.batchRawMessage.getBatchMessageSource();
                this.bufferedReader = new BufferedReader(batchMessageReader.getReader());
                this.skipHeader = true;
            }
            return this.getMessageFromReader();
        }
        if (this.batchRawMessage.getBatchMessageSource() instanceof BatchMessageReceiver) {
            return this.getMessageFromReceiver();
        }
        return null;
    }

    private String getMessageFromReader() throws Exception {
        String message = this.getMessage(this.bufferedReader, this.skipHeader);
        this.skipHeader = false;
        return message;
    }

    private String getMessageFromReceiver() throws Exception {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private String getMessage(BufferedReader in, boolean skipHeader) throws Exception {
        recDelim = this.delimitedReader.getRecordDelimiter();
        lookAhead = "";
        batchProperties = (DelimitedBatchProperties)this.getBatchProperties();
        if (skipHeader && batchProperties.getBatchSkipRecords() > 0) {
            for (i = 0; i < batchProperties.getBatchSkipRecords(); ++i) {
                do {
                    ch = this.delimitedReader.getChar(in, null);
                    lookAhead = this.delimitedReader.peekChars(in, recDelim.length());
                } while (ch != -1 && !lookAhead.equals(recDelim));
                if (!lookAhead.equals(recDelim)) continue;
                for (j = 0; j < recDelim.length(); ++j) {
                    ch = this.delimitedReader.getChar(in, null);
                }
            }
        }
        message = new StringBuilder();
        splitOption = batchProperties.getSplitType();
        if (splitOption == DelimitedBatchProperties.SplitType.Record) {
            this.delimitedReader.getRecord(in, message);
        } else if (splitOption == DelimitedBatchProperties.SplitType.Delimiter) {
            if (StringUtils.isEmpty((CharSequence)batchProperties.getBatchMessageDelimiter())) {
                throw new BatchMessageException("No batch message delimiter was set.");
            }
            if (this.batchMessageDelimiter == null) {
                this.batchMessageDelimiter = StringUtil.unescape((String)batchProperties.getBatchMessageDelimiter());
            }
            while ((record = this.delimitedReader.getRecord(in, message)) != null) {
                lookAhead = this.delimitedReader.peekChars(in, this.batchMessageDelimiter.length());
                if (!lookAhead.equals(this.batchMessageDelimiter)) continue;
                for (i = 0; i < this.batchMessageDelimiter.length(); ++i) {
                    ch = this.delimitedReader.getChar(in, null);
                }
                if (batchProperties.isBatchMessageDelimiterIncluded()) {
                    message.append(this.batchMessageDelimiter);
                }
                break;
            }
        } else if (splitOption == DelimitedBatchProperties.SplitType.Grouping_Column) {
            if (StringUtils.isEmpty((CharSequence)batchProperties.getBatchGroupingColumn())) {
                throw new BatchMessageException("No batch grouping column was set.");
            }
            record = this.delimitedReader.getRecord(in, message);
            if (record != null) {
                if (this.groupingColumnIndex == null) {
                    this.updateGroupingColumnIndex(batchProperties.getBatchGroupingColumn(), this.serializationProperties.getColumnNames());
                }
                lastColumnValue = (String)record.get(this.groupingColumnIndex);
                while ((record = this.delimitedReader.getRecord(in, recordText = new StringBuilder())) != null) {
                    if (!((String)record.get(this.groupingColumnIndex)).equals(lastColumnValue)) {
                        this.delimitedReader.ungetRecord(record, recordText.toString());
                        break;
                    }
                    message.append(recordText.toString());
                }
            }
        } else if (splitOption == DelimitedBatchProperties.SplitType.JavaScript) {
            if (StringUtils.isEmpty((CharSequence)batchProperties.getBatchScript())) {
                throw new BatchMessageException("No batch script was set.");
            }
            try {
                batchSkipRecords = batchProperties.getBatchSkipRecords();
                batchScriptId = ScriptController.getScriptId((String)"Batch", (String)this.sourceConnector.getChannelId());
                debug = ((DebuggableBatchAdaptorFactory)this.getFactory()).isDebug();
                contextFactory = this.getContextFactoryAndRecompile(this.contextFactoryController, debug, batchScriptId, batchProperties.getBatchScript());
                this.triggerDebug(debug);
                result = (String)JavaScriptUtil.execute((JavaScriptTask)new /* Unavailable Anonymous Inner Class!! */);
                if (result == null) ** GOTO lbl77
                message.append(result);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (JavaScriptExecutorException e) {
                this.logger.error((Object)e.getCause());
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        } else {
            throw new BatchMessageException("No valid batch splitting method configured");
        }
        result = message.toString();
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    private Map<String, Object> getScopeObjects(Reader in, DelimitedSerializationProperties props, Boolean skipHeader, Integer batchSkipRecords) {
        HashMap<String, Object> scopeObjects = new HashMap<String, Object>();
        scopeObjects.put("reader", in);
        scopeObjects.put("columnDelimiter", this.delimitedReader.getColumnDelimiter());
        scopeObjects.put("recordDelimiter", this.delimitedReader.getRecordDelimiter());
        scopeObjects.put("columnWidths", props.getColumnWidths());
        scopeObjects.put("quoteToken", this.delimitedReader.getQuoteToken());
        scopeObjects.put("escapeWithDoubleQuote", props.isEscapeWithDoubleQuote());
        scopeObjects.put("quoteEscapeToken", this.delimitedReader.getQuoteEscapeToken());
        scopeObjects.put("ignoreCR", props.isIgnoreCR());
        if (skipHeader.booleanValue()) {
            scopeObjects.put("skipRecords", batchSkipRecords);
        } else {
            scopeObjects.put("skipRecords", 0);
        }
        scopeObjects.put("sourceMap", new SourceMap(Collections.unmodifiableMap(this.batchRawMessage.getSourceMap())));
        return scopeObjects;
    }

    private void updateGroupingColumnIndex(String batchGroupingColumn, String[] columnNames) {
        if (this.groupingColumnIndex == null) {
            this.groupingColumnIndex = -1;
            if (StringUtils.isNotEmpty((CharSequence)batchGroupingColumn)) {
                this.groupingColumnIndex = 0;
                if (columnNames == null) {
                    int index = batchGroupingColumn.length() - 1;
                    int len = 0;
                    while (index >= 0 && Character.isDigit(batchGroupingColumn.charAt(index))) {
                        --index;
                        ++len;
                    }
                    if (len > 0) {
                        try {
                            this.groupingColumnIndex = Integer.valueOf(batchGroupingColumn.substring(batchGroupingColumn.length() - len, batchGroupingColumn.length())) - 1;
                        }
                        catch (NumberFormatException e) {
                            this.logger.warn("Invalid number format in Split Batch by Grouping Column (defaulting to first column): " + batchGroupingColumn.substring(batchGroupingColumn.length() - len, batchGroupingColumn.length()));
                        }
                    } else {
                        this.logger.warn("Unknown batch grouping column (defaulting to first column): " + batchGroupingColumn);
                    }
                } else {
                    int i;
                    for (i = 0; i < columnNames.length; ++i) {
                        if (!columnNames[i].equals(batchGroupingColumn)) continue;
                        this.groupingColumnIndex = i;
                        break;
                    }
                    if (i == columnNames.length) {
                        this.logger.warn("Unknown batch grouping column (defaulting to first column): " + batchGroupingColumn);
                    }
                }
            }
        }
    }

    static /* synthetic */ SourceConnector access$000(DelimitedBatchAdaptor x0) {
        return x0.sourceConnector;
    }

    static /* synthetic */ SourceConnector access$100(DelimitedBatchAdaptor x0) {
        return x0.sourceConnector;
    }
}

