/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.wbmp;

import com.sun.media.imageioimpl.plugins.wbmp.WBMPImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class WBMPImageReaderSpi
extends ImageReaderSpi {
    private static String[] writerSpiNames = new String[]{"com.sun.media.imageioimpl.plugins.wbmp.WBMPImageWriterSpi"};
    private static String[] formatNames = new String[]{"wbmp", "WBMP"};
    private static String[] entensions = new String[]{"wbmp"};
    private static String[] mimeType = new String[]{"image/vnd.wap.wbmp"};
    private boolean registered = false;

    public WBMPImageReaderSpi() {
        super("Sun Microsystems, Inc.", "0.5", formatNames, entensions, mimeType, "com.sun.media.imageioimpl.plugins.wbmp.WBMPImageWriter", ImageReaderSpi.STANDARD_INPUT_TYPE, writerSpiNames, true, null, null, null, null, true, null, null, null, null);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    public String getDescription(Locale locale) {
        return "Standard WBMP Image Reader";
    }

    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        byte[] b = new byte[3];
        stream.mark();
        stream.readFully(b);
        stream.reset();
        return b[0] == 0 && b[1] == 0 && ((b[2] & 0x8F) != 0 || (b[2] & 0x7F) != 0);
    }

    public ImageReader createReaderInstance(Object extension) throws IIOException {
        return new WBMPImageReader(this);
    }
}

