/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.fileformat.reader;

import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.DataEntryURLBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.FileTypeBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.SignatureBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.UUIDBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.UUIDListBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.XMLBox;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.fileformat.FileFormatBoxes;
import jj2000.j2k.io.RandomAccessIO;

public class FileFormatReader
implements FileFormatBoxes {
    private RandomAccessIO in;
    private Vector codeStreamPos;
    private Vector codeStreamLength;
    private ColorModel colorModel = null;
    private J2KMetadata metadata;
    private int width;
    private int height;
    private int numComp;
    private int bitDepth;
    private int compressionType;
    private int unknownColor;
    private int intelProp;
    private byte[] bitDepths;
    private byte[][] lut;
    private byte[] compSize;
    private short[] comps;
    private byte[] type;
    private byte[] maps;
    private short[] channels;
    private short[] cType;
    private short[] associations;
    private int colorSpaceType;
    private ICC_Profile profile;

    public FileFormatReader(RandomAccessIO in, J2KMetadata metadata) {
        this.in = in;
        this.metadata = metadata;
    }

    public void readFileFormat() throws IOException, EOFException {
        boolean foundCodeStreamBoxes = false;
        long longLength = 0L;
        boolean jp2HeaderBoxFound = false;
        boolean lastBoxFound = false;
        try {
            int pos = this.in.getPos();
            if (this.in.readInt() != 12 || this.in.readInt() != 1783636000 || this.in.readInt() != 218793738) {
                this.in.seek(pos);
                short marker = this.in.readShort();
                if (marker != -177) {
                    throw new Error("File is neither valid JP2 file nor valid JPEG 2000 codestream");
                }
                this.in.seek(pos);
                if (this.codeStreamPos == null) {
                    this.codeStreamPos = new Vector();
                }
                this.codeStreamPos.addElement(new Integer(pos));
                return;
            }
            if (this.metadata != null) {
                this.metadata.addNode(new SignatureBox());
            }
            while (!lastBoxFound) {
                int length;
                pos = this.in.getPos();
                if (pos + (length = this.in.readInt()) == this.in.length()) {
                    lastBoxFound = true;
                }
                int box = this.in.readInt();
                if (length == 0) {
                    lastBoxFound = true;
                    length = this.in.length() - this.in.getPos();
                } else {
                    if (length == 1) {
                        longLength = this.in.readLong();
                        throw new IOException("File too long.");
                    }
                    longLength = 0L;
                }
                pos = this.in.getPos();
                length -= 8;
                switch (box) {
                    case 1718909296: {
                        this.readFileTypeBox(length + 8, longLength);
                        break;
                    }
                    case 1785737827: {
                        if (!jp2HeaderBoxFound) {
                            throw new Error("Invalid JP2 file: JP2Header box not found before Contiguous codestream box ");
                        }
                        this.readContiguousCodeStreamBox(length + 8, longLength);
                        break;
                    }
                    case 1785737832: {
                        if (jp2HeaderBoxFound) {
                            throw new Error("Invalid JP2 file: Multiple JP2Header boxes found");
                        }
                        this.readJP2HeaderBox(length + 8);
                        jp2HeaderBoxFound = true;
                        length = 0;
                        break;
                    }
                    case 1768449138: {
                        this.readImageHeaderBox(length);
                        break;
                    }
                    case 1685074537: {
                        this.readIntPropertyBox(length);
                        break;
                    }
                    case 2020437024: {
                        this.readXMLBox(length);
                        break;
                    }
                    case 1969843814: {
                        length = 0;
                        break;
                    }
                    case 1970628964: {
                        this.readUUIDBox(length);
                        break;
                    }
                    case 1969451892: {
                        this.readUUIDListBox(length);
                        break;
                    }
                    case 1970433056: {
                        this.readURLBox(length);
                        break;
                    }
                    case 1885564018: {
                        this.readPaletteBox(length);
                        break;
                    }
                    case 1651532643: {
                        this.readBitsPerComponentBox(length);
                        break;
                    }
                    case 1668112752: {
                        this.readComponentMappingBox(length);
                        break;
                    }
                    case 1668246642: {
                        this.readColourSpecificationBox(length);
                        break;
                    }
                    case 1667523942: {
                        this.readChannelDefinitionBox(length);
                        break;
                    }
                    case 1919251232: {
                        length = 0;
                        break;
                    }
                    case 1919251299: 
                    case 1919251300: {
                        this.readResolutionBox(box, length);
                        break;
                    }
                    default: {
                        if (this.metadata == null) break;
                        byte[] data = new byte[length];
                        this.in.readFully(data, 0, length);
                        this.metadata.addNode(new Box(length + 8, box, longLength, data));
                    }
                }
                if (lastBoxFound) continue;
                this.in.seek(pos + length);
            }
        }
        catch (EOFException e) {
            throw new Error("EOF reached before finding Contiguous Codestream Box");
        }
        if (this.codeStreamPos.size() == 0) {
            throw new Error("Invalid JP2 file: Contiguous codestream box missing");
        }
    }

    public boolean readFileTypeBox(int length, long longLength) throws IOException, EOFException {
        boolean foundComp = false;
        if (length == 1) {
            longLength = this.in.readLong();
            throw new IOException("File too long.");
        }
        if (this.in.readInt() != 1785737760) {
            return false;
        }
        int minorVersion = this.in.readInt();
        int nComp = (length - 16) / 4;
        int[] comp = new int[nComp];
        int i = 0;
        while (i < nComp) {
            comp[i] = this.in.readInt();
            if (comp[i] == 1785737760) {
                foundComp = true;
            }
            ++i;
        }
        if (!foundComp) {
            return false;
        }
        if (this.metadata != null) {
            this.metadata.addNode(new FileTypeBox(1785737760, minorVersion, comp));
        }
        return true;
    }

    public boolean readJP2HeaderBox(int length) throws IOException, EOFException {
        if (length == 0) {
            throw new Error("Zero-length of JP2Header Box");
        }
        return true;
    }

    public boolean readImageHeaderBox(int length) throws IOException, EOFException {
        if (length == 0) {
            throw new Error("Zero-length of JP2Header Box");
        }
        this.height = this.in.readInt();
        this.width = this.in.readInt();
        this.numComp = this.in.readShort();
        this.bitDepth = this.in.readByte();
        this.compressionType = this.in.readByte();
        this.unknownColor = this.in.readByte();
        this.intelProp = this.in.readByte();
        if (this.metadata != null) {
            this.metadata.addNode(new HeaderBox(this.height, this.width, this.numComp, this.bitDepth, this.compressionType, this.unknownColor, this.intelProp));
        }
        return true;
    }

    public boolean readContiguousCodeStreamBox(int length, long longLength) throws IOException, EOFException {
        int ccpos = this.in.getPos();
        if (this.codeStreamPos == null) {
            this.codeStreamPos = new Vector();
        }
        this.codeStreamPos.addElement(new Integer(ccpos));
        if (this.codeStreamLength == null) {
            this.codeStreamLength = new Vector();
        }
        this.codeStreamLength.addElement(new Integer(length));
        return true;
    }

    public void readIntPropertyBox(int length) throws IOException {
        if (this.metadata != null) {
            byte[] data = new byte[length];
            this.in.readFully(data, 0, length);
            this.metadata.addNode(new Box(length + 8, 1785737833, data));
        }
    }

    public void readXMLBox(int length) throws IOException {
        if (this.metadata != null) {
            byte[] data = new byte[length];
            this.in.readFully(data, 0, length);
            this.metadata.addNode(new XMLBox(data));
        }
    }

    public void readURLBox(int length) throws IOException {
        if (this.metadata != null) {
            byte[] data = new byte[length];
            this.in.readFully(data, 0, length);
            this.metadata.addNode(new DataEntryURLBox(data));
        }
    }

    public void readUUIDBox(int length) throws IOException {
        if (this.metadata != null) {
            byte[] data = new byte[length];
            this.in.readFully(data, 0, length);
            this.metadata.addNode(new UUIDBox(data));
        }
    }

    public void readUUIDListBox(int length) throws IOException {
        if (this.metadata != null) {
            byte[] data = new byte[length];
            this.in.readFully(data, 0, length);
            this.metadata.addNode(new UUIDListBox(data));
        }
    }

    public void readPaletteBox(int length) throws IOException {
        int pos = this.in.getPos();
        int lutSize = this.in.readShort();
        int numComp = this.in.readByte();
        this.compSize = new byte[numComp];
        int i = 0;
        while (i < numComp) {
            this.compSize[i] = this.in.readByte();
            ++i;
        }
        this.lut = new byte[numComp][lutSize];
        int n = 0;
        while (n < lutSize) {
            int c = 0;
            while (c < numComp) {
                int depth = 1 + (this.compSize[c] & 0x7F);
                if (depth > 32) {
                    depth = 32;
                }
                int numBytes = depth + 7 >> 3;
                int mask = (1 << depth) - 1;
                byte[] buf = new byte[numBytes];
                this.in.readFully(buf, 0, numBytes);
                int val = 0;
                int k = 0;
                while (k < numBytes) {
                    val = buf[k] + (val << 8);
                    ++k;
                }
                this.lut[c][n] = (byte)val;
                ++c;
            }
            ++n;
        }
        if (this.metadata != null) {
            this.metadata.addNode(new PaletteBox(length, this.compSize, this.lut));
        }
    }

    public void readComponentMappingBox(int length) throws IOException {
        int num = length / 4;
        this.comps = new short[num];
        this.type = new byte[num];
        this.maps = new byte[num];
        int i = 0;
        while (i < num) {
            this.comps[i] = this.in.readShort();
            this.type[i] = this.in.readByte();
            this.maps[i] = this.in.readByte();
            ++i;
        }
        if (this.metadata != null) {
            this.metadata.addNode(new ComponentMappingBox(this.comps, this.type, this.maps));
        }
    }

    public void readChannelDefinitionBox(int length) throws IOException {
        int num = this.in.readShort();
        this.channels = new short[num];
        this.cType = new short[num];
        this.associations = new short[num];
        int i = 0;
        while (i < num) {
            this.channels[i] = this.in.readShort();
            this.cType[i] = this.in.readShort();
            this.associations[i] = this.in.readShort();
            ++i;
        }
        if (this.metadata != null) {
            this.metadata.addNode(new ChannelDefinitionBox(this.channels, this.cType, this.associations));
        }
    }

    public void readBitsPerComponentBox(int length) throws IOException {
        this.bitDepths = new byte[length];
        this.in.readFully(this.bitDepths, 0, length);
        if (this.metadata != null) {
            this.metadata.addNode(new BitsPerComponentBox(this.bitDepths));
        }
    }

    public void readColourSpecificationBox(int length) throws IOException {
        byte method = this.in.readByte();
        byte prec = this.in.readByte();
        byte approx = this.in.readByte();
        if (method == 2) {
            byte[] data = new byte[length - 3];
            this.in.readFully(data, 0, data.length);
            this.profile = ICC_Profile.getInstance(data);
        } else {
            this.colorSpaceType = this.in.readInt();
        }
        if (this.metadata != null) {
            this.metadata.addNode(new ColorSpecificationBox(method, prec, approx, this.colorSpaceType, this.profile));
        }
    }

    public void readResolutionBox(int type, int length) throws IOException {
        byte[] data = new byte[length];
        this.in.readFully(data, 0, length);
        if (this.metadata != null) {
            this.metadata.addNode(new ResolutionBox(type, data));
        }
    }

    public long[] getCodeStreamPos() {
        int size = this.codeStreamPos.size();
        long[] pos = new long[size];
        int i = 0;
        while (i < size) {
            pos[i] = ((Integer)this.codeStreamPos.elementAt(i)).longValue();
            ++i;
        }
        return pos;
    }

    public int getFirstCodeStreamPos() {
        return (Integer)this.codeStreamPos.elementAt(0);
    }

    public int getFirstCodeStreamLength() {
        return (Integer)this.codeStreamLength.elementAt(0);
    }

    public ColorModel getColorModel() {
        if (this.lut != null) {
            int numComp = this.lut.length;
            int maxDepth = 1 + (this.bitDepth & 0x7F);
            if (this.maps == null) {
                this.maps = new byte[numComp];
                int i = 0;
                while (i < numComp) {
                    this.maps[i] = (byte)i;
                    ++i;
                }
            }
            if (numComp == 3) {
                this.colorModel = new IndexColorModel(maxDepth, this.lut[0].length, this.lut[this.maps[0]], this.lut[this.maps[1]], this.lut[this.maps[2]]);
            } else if (numComp == 4) {
                this.colorModel = new IndexColorModel(maxDepth, this.lut[0].length, this.lut[this.maps[0]], this.lut[this.maps[1]], this.lut[this.maps[2]], this.lut[this.maps[3]]);
            }
        } else if (this.channels != null) {
            boolean isSigned;
            int i;
            boolean hasAlpha = false;
            int alphaChannel = this.numComp - 1;
            int i2 = 0;
            while (i2 < this.channels.length) {
                if (this.cType[i2] == 1 && this.channels[i2] == alphaChannel) {
                    hasAlpha = true;
                }
                ++i2;
            }
            boolean[] isPremultiplied = new boolean[]{false};
            if (hasAlpha) {
                isPremultiplied = new boolean[alphaChannel];
                int i3 = 0;
                while (i3 < alphaChannel) {
                    isPremultiplied[i3] = false;
                    ++i3;
                }
                int i4 = 0;
                while (i4 < this.channels.length) {
                    if (this.cType[i4] == 2) {
                        isPremultiplied[this.associations[i4] - 1] = true;
                    }
                    ++i4;
                }
                i = 1;
                while (i < alphaChannel) {
                    isPremultiplied[0] = isPremultiplied[0] & isPremultiplied[i];
                    ++i;
                }
            }
            ColorSpace cs = null;
            if (this.profile != null) {
                cs = new ICC_ColorSpace(this.profile);
            } else if (this.colorSpaceType == 16) {
                cs = ColorSpace.getInstance(1000);
            } else if (this.colorSpaceType == 17) {
                cs = ColorSpace.getInstance(1003);
            } else if (this.colorSpaceType == 18) {
                cs = ColorSpace.getInstance(1002);
            }
            int[] bits = new int[this.numComp];
            i = 0;
            while (i < this.numComp) {
                bits[i] = this.bitDepths != null ? (this.bitDepths[i] & 0x7F) + 1 : (this.bitDepth & 0x7F) + 1;
                ++i;
            }
            int maxBitDepth = 1 + (this.bitDepth & 0x7F);
            boolean bl = isSigned = (this.bitDepth & 0x80) == 128;
            if (this.bitDepths != null) {
                boolean bl2 = isSigned = (this.bitDepths[0] & 0x80) == 128;
            }
            if (this.bitDepths != null) {
                int i5 = 0;
                while (i5 < this.numComp) {
                    if (bits[i5] > maxBitDepth) {
                        maxBitDepth = bits[i5];
                    }
                    ++i5;
                }
            }
            int type = -1;
            if (maxBitDepth <= 8) {
                type = 0;
            } else if (maxBitDepth <= 16) {
                type = isSigned ? 2 : 1;
            } else if (maxBitDepth <= 32) {
                type = 3;
            }
            if (type == -1) {
                return null;
            }
            if (cs != null) {
                this.colorModel = new ComponentColorModel(cs, bits, hasAlpha, isPremultiplied[0], hasAlpha ? 3 : 1, type);
            }
        }
        return this.colorModel;
    }
}

